/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import com.google.common.collect.Range;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.concurrent.Callable;
import org.aksw.commons.rx.lookup.ListPaginator;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecFactoryQuery;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;

public abstract class PaginatorQueryBase<T>
implements ListPaginator<T> {
    protected QueryExecFactoryQuery qef;
    protected Query query;

    protected abstract Flowable<T> obtainResultIterator(Callable<QueryExec> var1);

    public PaginatorQueryBase(QueryExecFactoryQuery qef, Query query) {
        this.qef = qef;
        this.query = query;
    }

    public Flowable<T> apply(Range<Long> range) {
        Query clonedQuery = QueryTransformOps.shallowCopy((Query)this.query);
        range = Range.atLeast((Comparable)Long.valueOf(0L)).intersection(range);
        QueryUtils.applyRange((Query)clonedQuery, (Range)range);
        Flowable<T> result = this.obtainResultIterator(() -> this.qef.create(clonedQuery));
        return result;
    }

    public Single<Range<Long>> fetchCount(Long itemLimit, Long rowLimit) {
        Single result = SparqlRx.fetchCountQuery((QueryExecFactoryQuery)this.qef, (Query)this.query, (Long)itemLimit, (Long)rowLimit);
        return result;
    }
}

