/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import java.net.http.HttpClient;
import java.util.function.Function;
import org.aksw.jena_sparql_api.core.SparqlServiceImpl;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactoryHttp;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.update.FluentSparqlService;
import org.aksw.jenax.connectionless.SparqlService;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtParserImpl;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;

public class SparqlServiceUtils {
    public static SparqlService createSparqlServiceMem(String serviceUri, DatasetDescription datasetDescription, HttpClient httpClient) {
        DatasetGraph dg = DatasetGraphFactory.create();
        SparqlService result = (SparqlService)((FluentSparqlService)FluentSparqlService.from(dg).config().withParser((Function<String, SparqlStmt>)SparqlStmtParserImpl.create((Syntax)Syntax.syntaxARQ, (boolean)false)).withDatasetDescription(datasetDescription).end()).create();
        return result;
    }

    public static SparqlService createSparqlService(String serviceUri, DatasetDescription datasetDescription, HttpClient httpClient) {
        SparqlService result = serviceUri != null && serviceUri.startsWith("mem://") ? SparqlServiceUtils.createSparqlServiceMem(serviceUri, datasetDescription, httpClient) : SparqlServiceUtils.createSparqlServiceHttp(serviceUri, datasetDescription, httpClient);
        return result;
    }

    public static SparqlService createSparqlServiceHttp(String serviceUri, DatasetDescription datasetDescription, HttpClient httpClient) {
        QueryExecutionFactoryHttp qef = new QueryExecutionFactoryHttp(serviceUri, datasetDescription, httpClient);
        UpdateExecutionFactoryHttp uef = new UpdateExecutionFactoryHttp(serviceUri, datasetDescription, httpClient);
        SparqlServiceImpl result = new SparqlServiceImpl(serviceUri, datasetDescription, qef, uef);
        return result;
    }
}

