/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import java.util.Collection;
import org.aksw.jena_sparql_api.core.UsernamePasswordCredentials;
import org.aksw.jenax.annotation.reprogen.Base;
import org.aksw.jenax.annotation.reprogen.DefaultIri;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.RdfType;
import org.apache.jena.sparql.core.DatasetDescription;

@Base(value="http://jpa.aksw.org/ontology/")
@RdfType(value="SparqlServiceReference")
@DefaultIri(value="r:#{#md5(serviceURL + datasetDescription.defaultGraphURIs + datasetDescription.namedGraphURIs)}")
public class SparqlServiceReference {
    @Iri
    private final String serviceURL;
    @Iri
    private final DatasetDescription datasetDescription;
    protected final UsernamePasswordCredentials credentials;

    public SparqlServiceReference(String serviceURL, DatasetDescription datasetDescription) {
        this(serviceURL, datasetDescription, null);
    }

    public SparqlServiceReference(String serviceURL, DatasetDescription datasetDescription, UsernamePasswordCredentials credentials) {
        this.serviceURL = serviceURL;
        this.datasetDescription = datasetDescription;
        this.credentials = credentials;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public DatasetDescription getDatasetDescription() {
        return this.datasetDescription;
    }

    public Collection<String> getDefaultGraphURIs() {
        return this.datasetDescription.getDefaultGraphURIs();
    }

    public Collection<String> getNamedGraphURIs() {
        return this.datasetDescription.getNamedGraphURIs();
    }

    public UsernamePasswordCredentials getCredentials() {
        return this.credentials;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.credentials == null ? 0 : this.credentials.hashCode());
        result = 31 * result + (this.datasetDescription == null ? 0 : this.datasetDescription.hashCode());
        result = 31 * result + (this.serviceURL == null ? 0 : this.serviceURL.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparqlServiceReference other = (SparqlServiceReference)obj;
        if (this.credentials == null ? other.credentials != null : !this.credentials.equals(other.credentials)) {
            return false;
        }
        if (this.datasetDescription == null ? other.datasetDescription != null : !this.datasetDescription.equals(other.datasetDescription)) {
            return false;
        }
        return !(this.serviceURL == null ? other.serviceURL != null : !this.serviceURL.equals(other.serviceURL));
    }

    public String toString() {
        return "SparqlServiceReference [serviceURL=" + this.serviceURL + ", datasetDescription=" + String.valueOf(this.datasetDescription) + ", authenticator=" + String.valueOf(this.credentials) + "]";
    }
}

