/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import com.google.common.base.Supplier;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.aksw.jena_sparql_api.cache.core.QueryExecutionFactoryCacheEx;
import org.aksw.jena_sparql_api.cache.extra.CacheBackend;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontendImpl;
import org.aksw.jena_sparql_api.core.FluentFnBase;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryDatasetDescription;
import org.aksw.jena_sparql_api.core.QueryExecutionFactorySelect;
import org.aksw.jena_sparql_api.delay.core.QueryExecutionFactoryDelay;
import org.aksw.jena_sparql_api.delay.extra.Delayer;
import org.aksw.jena_sparql_api.limit.QueryExecutionFactoryLimit;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.jena_sparql_api.parse.QueryExecutionFactoryParse;
import org.aksw.jena_sparql_api.post_process.QueryExecutionFactoryPostProcess;
import org.aksw.jena_sparql_api.prefix.core.QueryExecutionFactoryPrefix;
import org.aksw.jena_sparql_api.retry.core.QueryExecutionFactoryRetry;
import org.aksw.jena_sparql_api.timeout.QueryExecutionTimeoutExogeneous;
import org.aksw.jena_sparql_api.transform.result_set.QueryExecutionFactoryTransformResult;
import org.aksw.jenax.arq.util.query.QueryTransform;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecFactories;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecFactory;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecFactoryQuery;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecFactoryQueryTransform;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactories;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQueryTransform;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.graph.NodeTransform;

public class FluentQueryExecutionFactoryFn<P>
extends FluentFnBase<QueryExecutionFactory, P> {
    public FluentQueryExecutionFactoryFn() {
        this(null, null);
    }

    public FluentQueryExecutionFactoryFn<P> compose(Function<QueryExecutionFactory, QueryExecutionFactory> nextFn) {
        super.compose(nextFn);
        return this;
    }

    public FluentQueryExecutionFactoryFn(Supplier<P> parentSupplier, Function<QueryExecutionFactory, QueryExecutionFactory> fn) {
        super(true);
        this.parentSupplier = parentSupplier;
        this.fn = fn;
    }

    public FluentQueryExecutionFactoryFn<P> withDelay(int delayDuration, TimeUnit delayTimeUnit) {
        this.compose(qef -> new QueryExecutionFactoryDelay((QueryExecutionFactory)qef, delayDuration, delayTimeUnit));
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withDelay(Delayer delayer) {
        if (delayer != null) {
            this.compose(qef -> new QueryExecutionFactoryDelay((QueryExecutionFactory)qef, delayer));
        }
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withPrefixes(PrefixMapping pm, boolean doClone) {
        this.compose(qef -> new QueryExecutionFactoryPrefix((QueryExecutionFactory)qef, pm, doClone));
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withParser(Function<String, Query> parser) {
        this.compose(qef -> new QueryExecutionFactoryParse((QueryExecutionFactory)qef, parser));
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withClientSideConstruct() {
        this.compose((Function)new Function<QueryExecutionFactory, QueryExecutionFactory>(){

            @Override
            public QueryExecutionFactory apply(QueryExecutionFactory qef) {
                QueryExecutionFactorySelect r = new QueryExecutionFactorySelect(qef);
                return r;
            }
        });
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withPagination(final int pageSize) {
        this.compose((Function)new Function<QueryExecutionFactory, QueryExecutionFactory>(){

            @Override
            public QueryExecutionFactory apply(QueryExecutionFactory qef) {
                QueryExecutionFactoryPaginated r = new QueryExecutionFactoryPaginated(qef, pageSize);
                return r;
            }
        });
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withRetry(int retryCount, long retryDelayDuration, TimeUnit retryDelayTimeUnit) {
        this.compose(qef -> new QueryExecutionFactoryRetry((QueryExecutionFactory)qef, retryCount, retryDelayDuration, retryDelayTimeUnit));
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withCache(CacheBackend cache) {
        return this.withCache(new CacheFrontendImpl(cache));
    }

    public FluentQueryExecutionFactoryFn<P> withCache(CacheFrontend cache) {
        this.compose(qef -> new QueryExecutionFactoryCacheEx((QueryExecutionFactory)qef, cache));
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withResultTransform(NodeTransform nodeTransform) {
        this.compose(qef -> new QueryExecutionFactoryTransformResult((QueryExecutionFactory)qef, nodeTransform));
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withDefaultLimit(long limit, boolean doCloneQuery) {
        this.compose(qef -> new QueryExecutionFactoryLimit((QueryExecutionFactory)qef, doCloneQuery, limit));
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withQueryTransform(QueryTransform queryTransform) {
        this.compose(qef -> new QueryExecutionFactoryQueryTransform(qef, queryTransform));
        return this;
    }

    public static <T> Function<T, T> toFunction(Consumer<T> consumer) {
        return x -> {
            consumer.accept(x);
            return x;
        };
    }

    public FluentQueryExecutionFactoryFn<P> withPostProcessor(Consumer<QueryExecution> postProcessor) {
        this.withPostTransformer(FluentQueryExecutionFactoryFn.toFunction(postProcessor));
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withPostTransformer(Function<? super QueryExecution, ? extends QueryExecution> postProcessor) {
        this.compose(qef -> new QueryExecutionFactoryPostProcess((QueryExecutionFactory)qef, postProcessor));
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withExogeneousTimeout() {
        this.withPostTransformer(qe -> {
            QueryExecutionTimeoutExogeneous r = new QueryExecutionTimeoutExogeneous((QueryExecution)qe);
            return r;
        });
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withDatasetDescription(DatasetDescription datasetDescription) {
        this.compose(qef -> new QueryExecutionFactoryDatasetDescription((QueryExecutionFactory)qef, datasetDescription));
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> selectOnly() {
        this.compose(QueryExecutionFactorySelect::new);
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> composeExec(QueryExecFactoryQueryTransform decorizer) {
        this.compose(qef -> {
            QueryExecFactory before = QueryExecFactories.adapt((QueryExecutionFactory)qef);
            QueryExecFactoryQuery afterRaw = (QueryExecFactoryQuery)decorizer.apply((Object)before);
            QueryExecFactory after = QueryExecFactories.adapt((QueryExecFactoryQuery)afterRaw);
            return QueryExecutionFactories.adapt((QueryExecFactory)after);
        });
        return this;
    }

    public static FluentQueryExecutionFactoryFn<?> start() {
        return new FluentQueryExecutionFactoryFn();
    }
}

