/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.core;

import com.google.common.cache.Cache;
import java.net.http.HttpConnectTimeoutException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.aksw.jenax.dataaccess.sparql.execution.query.QueryExecutionWrapperBase;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;

public class QueryExecutionExceptionCache
extends QueryExecutionWrapperBase<QueryExecution> {
    protected Cache<String, Exception> exceptionCache;

    public QueryExecutionExceptionCache(QueryExecution decoratee, Cache<String, Exception> exceptionCache) {
        super(decoratee);
        this.exceptionCache = exceptionCache;
    }

    protected String getQueryStr() {
        Query query = this.getQuery();
        Objects.requireNonNull(query);
        String result = query.toString();
        return result;
    }

    protected void beforeExec() {
        String queryStr = this.getQueryStr();
        Exception e = (Exception)this.exceptionCache.getIfPresent((Object)queryStr);
        if (e != null) {
            throw new RuntimeException(e);
        }
    }

    protected void onException(Exception e) {
        List throwables = ExceptionUtils.getThrowableList((Throwable)e);
        for (Throwable t : throwables) {
            if (!(t instanceof TimeoutException) && !(t instanceof HttpConnectTimeoutException)) continue;
            String queryStr = this.getQueryStr();
            this.exceptionCache.put((Object)queryStr, (Object)e);
        }
        super.onException(e);
    }
}

