/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.advanced;

import com.esotericsoftware.kryo.pool.KryoPool;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Range;
import io.reactivex.rxjava3.core.Flowable;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.cache.AdvancedRangeCacheConfig;
import org.aksw.commons.io.cache.AdvancedRangeCacheConfigImpl;
import org.aksw.commons.io.cache.AdvancedRangeCacheImpl;
import org.aksw.commons.io.slice.Slice;
import org.aksw.commons.io.slice.SliceWithPagesSyncToDisk;
import org.aksw.commons.path.core.PathStr;
import org.aksw.commons.rx.cache.range.ListPaginatorWithAdvancedCache;
import org.aksw.commons.rx.lookup.ListPaginator;
import org.aksw.commons.store.object.key.api.ObjectStore;
import org.aksw.commons.store.object.key.impl.KryoUtils;
import org.aksw.commons.store.object.key.impl.ObjectStoreImpl;
import org.aksw.commons.store.object.path.api.ObjectSerializer;
import org.aksw.commons.store.object.path.impl.ObjectSerializerKryo;
import org.aksw.jena_sparql_api.lookup.ListPaginatorSparql;
import org.aksw.jenax.arq.util.binding.BindingUtils;
import org.aksw.jenax.arq.util.syntax.QueryHash;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecFactories;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecFactoryQuery;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecFactoryQueryTransform;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecFactoryQueryWrapperBase;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryTransform;
import org.aksw.jenax.io.kryo.jena.JenaKryoRegistratorLib;
import org.aksw.jenax.sparql.query.rx.ResultSetRxImpl;
import org.apache.jena.query.Query;
import org.apache.jena.rdflink.LinkSparqlQuery;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecFactoryQueryRangeCache
extends QueryExecFactoryQueryWrapperBase<QueryExecFactoryQuery> {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecFactoryQueryRangeCache.class);
    protected ObjectStore objectStore;
    protected AdvancedRangeCacheConfig cacheConfig;
    protected ArrayOps<Binding[]> arrayOps = ArrayOps.createFor(Binding.class);
    protected Cache<org.aksw.commons.path.core.Path<String>, ListPaginator<Binding>> queryToCache;

    public QueryExecFactoryQueryRangeCache(QueryExecFactoryQuery decoratee, ObjectStore objectStore, int maxCachedQueries, AdvancedRangeCacheConfig cacheConfig) {
        super(decoratee);
        this.objectStore = objectStore;
        this.cacheConfig = cacheConfig;
        this.queryToCache = CacheBuilder.newBuilder().maximumSize((long)maxCachedQueries).build();
    }

    public QueryExec create(Query query) {
        ListPaginator frontend;
        Range requestRange = QueryUtils.toRange((Query)query);
        Query bodyQueryWithoutSlice = QueryTransformOps.shallowCopy((Query)query);
        bodyQueryWithoutSlice.setOffset(Long.MIN_VALUE);
        bodyQueryWithoutSlice.setLimit(Long.MIN_VALUE);
        QueryHash hash = QueryHash.createHash((Query)bodyQueryWithoutSlice);
        String queryHash = hash.toString();
        logger.debug("Query w/o slice: " + String.valueOf(bodyQueryWithoutSlice));
        logger.debug("Query hash: " + String.valueOf(hash) + " " + String.valueOf(requestRange));
        List resultVars = query.getProjectVars();
        try {
            PathStr objectStorePath = PathStr.parse((String)queryHash);
            frontend = (ListPaginator)this.queryToCache.get((Object)objectStorePath, () -> this.lambda$create$0(bodyQueryWithoutSlice, (org.aksw.commons.path.core.Path)objectStorePath));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ListPaginator tmp = frontend.map(b -> BindingUtils.project((Binding)b, (Iterable)resultVars));
        Flowable flowable = (Flowable)tmp.apply((Object)requestRange);
        ResultSetRxImpl rs = ResultSetRxImpl.create((Query)query, (List)resultVars, (Flowable)flowable);
        QueryExec result = rs.asQueryExec();
        return result;
    }

    public static QueryExecFactoryQueryRangeCache create(QueryExecFactoryQuery decoratee, Path cacheFolder, int maxCachedQueries, AdvancedRangeCacheConfig cacheConfig) {
        KryoPool kryoPool = KryoUtils.createKryoPool(JenaKryoRegistratorLib::registerClasses);
        ObjectStore objectStore = ObjectStoreImpl.create((Path)cacheFolder, (ObjectSerializer)ObjectSerializerKryo.create((KryoPool)kryoPool));
        QueryExecFactoryQueryRangeCache result = new QueryExecFactoryQueryRangeCache(decoratee, objectStore, maxCachedQueries, cacheConfig);
        return result;
    }

    public static QueryExecFactoryQueryRangeCache create(QueryExecFactoryQuery decoratee, Path cacheFolder, long maxRequestSize) {
        AdvancedRangeCacheConfigImpl arcc = AdvancedRangeCacheConfigImpl.newDefaultsForObjects((long)maxRequestSize);
        QueryExecFactoryQueryRangeCache result = QueryExecFactoryQueryRangeCache.create(decoratee, cacheFolder, 1024, (AdvancedRangeCacheConfig)arcc);
        return result;
    }

    public static QueryExecFactoryQueryTransform createQueryExecMod(Path cacheDir, long maxRequestSize) {
        return qef -> QueryExecFactoryQueryRangeCache.create(qef, cacheDir, maxRequestSize);
    }

    public static LinkSparqlQueryTransform createLinkMod(Path cacheDir, long maxRequestSize) {
        return link -> {
            Object qef = QueryExecFactories.of((LinkSparqlQuery)link);
            qef = QueryExecFactoryQueryRangeCache.create((QueryExecFactoryQuery)qef, cacheDir, maxRequestSize);
            LinkSparqlQuery result = QueryExecFactories.toLink((QueryExecFactoryQuery)qef);
            return result;
        };
    }

    public static LinkSparqlQuery decorate(LinkSparqlQuery link, Path cacheDir, long maxRequestSize) {
        LinkSparqlQueryTransform mod = QueryExecFactoryQueryRangeCache.createLinkMod(cacheDir, maxRequestSize);
        LinkSparqlQuery result = (LinkSparqlQuery)mod.apply((Object)link);
        return result;
    }

    private /* synthetic */ ListPaginator lambda$create$0(Query bodyQueryWithoutSlice, org.aksw.commons.path.core.Path objectStorePath) throws Exception {
        ListPaginatorSparql backend = new ListPaginatorSparql(bodyQueryWithoutSlice, this.decoratee);
        SliceWithPagesSyncToDisk sliceBuffer = SliceWithPagesSyncToDisk.create(this.arrayOps, (ObjectStore)this.objectStore, (org.aksw.commons.path.core.Path)objectStorePath, (int)this.cacheConfig.getPageSize(), (Duration)this.cacheConfig.getTerminationDelay());
        AdvancedRangeCacheImpl.Builder cacheBuilder = AdvancedRangeCacheImpl.newBuilder().setWorkerBulkSize(128).setSlice((Slice)sliceBuffer).setRequestLimit(this.cacheConfig.getMaxRequestSize()).setTerminationDelay(this.cacheConfig.getTerminationDelay());
        ListPaginatorWithAdvancedCache r = ListPaginatorWithAdvancedCache.create((ListPaginator)backend, (AdvancedRangeCacheImpl.Builder)cacheBuilder);
        logger.debug("Is cache complete? " + r.getCore().getSlice().isComplete());
        return r;
    }
}

