/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Map;
import org.aksw.commons.rx.lookup.LookupService;
import org.aksw.jenax.arq.util.expr.ExprListUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.table.TableN;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupServiceSparqlQuery
implements LookupService<Node, Table> {
    private static final Logger logger = LoggerFactory.getLogger(LookupServiceSparqlQuery.class);
    protected QueryExecutionFactoryQuery sparqlService;
    protected Query query;
    protected Var var;

    public LookupServiceSparqlQuery(QueryExecutionFactoryQuery sparqlService, Query query, Var var) {
        this.sparqlService = sparqlService;
        this.query = query;
        this.var = var;
    }

    public Flowable<Map.Entry<Node, Table>> apply(Iterable<Node> keys) {
        Flowable result;
        if (!Iterables.isEmpty(keys)) {
            ExprList exprs = ExprListUtils.nodesToExprs(keys);
            E_OneOf expr = new E_OneOf((Expr)new ExprVar(this.var), exprs);
            ElementFilter filterElement = new ElementFilter((Expr)expr);
            Query q = this.query.cloneQuery();
            Element newElement = ElementUtils.mergeElements((Element)q.getQueryPattern(), (Element)filterElement);
            q.setQueryPattern(newElement);
            logger.debug("Looking up: " + String.valueOf(q));
            result = SparqlRx.execSelectRaw(() -> this.sparqlService.createQueryExecution(q)).groupBy(b -> b.get(this.var)).flatMapSingle(groups -> groups.collectInto((Object)new TableN(), (t, b) -> t.addBinding(b)).map(x -> Maps.immutableEntry((Object)((Node)groups.getKey()), (Object)x)));
        } else {
            result = Flowable.empty();
        }
        return result;
    }

    public static class Builder {
        protected QueryExecutionFactory qef;
        protected Query query;
        protected String queryString;
        protected Syntax syntax;

        public void setConnection(RDFConnection conn) {
        }

        public void setQuery(Query query) {
        }

        public void setQuery(String queryString, Syntax syntax) {
        }

        public LookupServiceSparqlQuery build() {
            return null;
        }
    }
}

