/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core.utils;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.aksw.jena_sparql_api.core.utils.IteratorNQuads;
import org.aksw.jena_sparql_api.core.utils.ServiceUtils;
import org.aksw.jena_sparql_api.core.utils.SinkQuadsToCollection;
import org.aksw.jenax.arq.util.binding.TableUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryType;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetCloseable;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.aggregate.AggCount;
import org.apache.jena.sparql.expr.aggregate.AggCountDistinct;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionUtils {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionUtils.class);
    public static final Var vg = Var.alloc((String)"g");
    public static final Var vs = Var.alloc((String)"s");
    public static final Var vp = Var.alloc((String)"p");
    public static final Var vo = Var.alloc((String)"o");

    public static Table execSelectTable(Supplier<QueryExecution> qeSupp) {
        Table result;
        try (QueryExecution qe = qeSupp.get();){
            ResultSet rs = qe.execSelect();
            result = TableUtils.createTable((ResultSet)rs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void abortAfterFirstRow(QueryExecution qe) {
        Query query = qe.getQuery();
        assert (query != null) : "QueryExecution did not tell us which query it is bound to - query was null";
        QueryType queryType = query.queryType();
        try {
            switch (queryType) {
                case ASK: {
                    qe.execAsk();
                    return;
                }
                case CONSTRUCT: {
                    Iterator itC = qe.execConstructTriples();
                    itC.hasNext();
                    return;
                }
                case DESCRIBE: {
                    Iterator itD = qe.execDescribeTriples();
                    itD.hasNext();
                    return;
                }
                case SELECT: {
                    ResultSet rs = qe.execSelect();
                    rs.hasNext();
                    return;
                }
                default: {
                    throw new RuntimeException("Unknown query type - should not happen: queryType = " + String.valueOf(queryType));
                }
            }
        }
        finally {
            qe.abort();
        }
    }

    public static long consume(QueryExecution qe) {
        Query query = qe.getQuery();
        assert (query != null) : "QueryExecution did not tell us which query it is bound to - query was null";
        QueryType queryType = query.queryType();
        return switch (queryType) {
            case QueryType.ASK -> {
                qe.execAsk();
                yield 1L;
            }
            case QueryType.CONSTRUCT -> {
                Iterator itC = qe.execConstructTriples();
                yield Iterators.size((Iterator)itC);
            }
            case QueryType.DESCRIBE -> {
                Iterator itD = qe.execDescribeTriples();
                yield Iterators.size((Iterator)itD);
            }
            case QueryType.SELECT -> {
                ResultSet rs = qe.execSelect();
                yield ResultSetFormatter.consume((ResultSet)rs);
            }
            default -> throw new RuntimeException("Unknown query type - should not happen: queryType = " + String.valueOf(queryType));
        };
    }

    public static void tryClose(Object obj) {
        if (obj instanceof AutoCloseable) {
            try {
                ((AutoCloseable)obj).close();
            }
            catch (Exception e) {
                logger.warn("Exception while closing", (Throwable)e);
            }
        } else if (obj instanceof Closeable) {
            ((Closeable)obj).close();
        }
    }

    public static ExtendedIterator<Triple> execConstruct(QueryExecutionFactory qef, Query query) {
        QueryExecution qe = qef.createQueryExecution(query);
        return QueryExecutionUtils.execConstruct(qe, query);
    }

    public static ExtendedIterator<Triple> execConstruct(QueryExecution qe, Query query) {
        Iterator it = qe.execConstructTriples();
        ExtendedIterator result = WrappedIterator.create((Iterator)Iter.onClose((Iterator)it, () -> {
            QueryExecutionUtils.tryClose(it);
            qe.close();
        }));
        return result;
    }

    public static boolean validate(QueryExecutionFactory qef, boolean suppressException) {
        boolean result;
        try {
            Query query = QueryFactory.create((String)"SELECT * { ?s a ?t } Limit 1");
            QueryExecution qe = qef.createQueryExecution(query);
            ResultSet rs = qe.execSelect();
            ResultSetFormatter.consume((ResultSet)rs);
            result = true;
        }
        catch (Exception e) {
            if (!suppressException) {
                throw new RuntimeException(e);
            }
            result = false;
        }
        return result;
    }

    public static Iterator<Quad> createIteratorDumpQuads(QueryExecutionFactory qef) {
        String queryStr = "Select ?g ?s ?p ?o { Graph ?g { ?s ?p ?o } }";
        QueryExecution qe = qef.createQueryExecution(queryStr);
        ResultSet tmp = qe.execSelect();
        ResultSetCloseable rs = new ResultSetCloseable(tmp, qe);
        IteratorNQuads result = new IteratorNQuads(rs);
        return result;
    }

    public static void createDumpNQuads(QueryExecutionFactory qef, Sink<Quad> sink) {
        Iterator<Quad> it = QueryExecutionUtils.createIteratorDumpQuads(qef);
        while (it.hasNext()) {
            Quad quad = it.next();
            sink.send((Object)quad);
        }
    }

    public static Set<Quad> createDumpNQuads(QueryExecutionFactory qef) {
        SinkQuadsToCollection<HashSet<Quad>> sink = SinkQuadsToCollection.createSinkHashSet();
        QueryExecutionUtils.createDumpNQuads(qef, sink);
        Set result = sink.getQuads();
        return result;
    }

    public static Iterator<Triple> createIteratorDumpTriples(QueryExecutionFactory qef) {
        String queryStr = "Construct { ?s ?p ?o } { ?s ?p ?o }";
        QueryExecution qe = qef.createQueryExecution(queryStr);
        Iterator result = qe.execConstructTriples();
        return result;
    }

    public static long fetchBindingCount(String serviceUrl, Query query) {
        long result;
        try (QueryExecution qe = (QueryExecution)((QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)QueryExecutionHTTP.newBuilder().endpoint(serviceUrl)).query(query)).build();){
            result = ResultSetFormatter.consume((ResultSet)qe.execSelect());
        }
        return result;
    }

    public static long countQuery(Query query, QueryExecutionFactory qef) {
        Element queryPattern;
        boolean needsWrapping = !query.getGroupBy().isEmpty() || !query.getAggregators().isEmpty();
        boolean useCountDistinct = !needsWrapping && query.isDistinct() && query.isQueryResultStar();
        AggCountDistinct agg = useCountDistinct ? new AggCountDistinct() : new AggCount();
        Query cQuery = new Query();
        cQuery.setQuerySelectType();
        cQuery.setPrefixMapping(query.getPrefixMapping());
        cQuery.getProject().add(Vars.c, (Expr)new ExprAggregator(Vars.x, (Aggregator)agg));
        if (needsWrapping) {
            Query q = query.cloneQuery();
            q.setPrefixMapping((PrefixMapping)new PrefixMappingImpl());
            queryPattern = new ElementSubQuery(q);
        } else {
            queryPattern = query.getQueryPattern();
        }
        cQuery.setQueryPattern(queryPattern);
        QueryExecution qe = qef.createQueryExecution(cQuery);
        long result = ServiceUtils.fetchInteger(qe, Vars.c).intValue();
        return result;
    }

    @Deprecated
    public static long countQueryOld(Query query, QueryExecutionFactory qef) {
        Var outputVar = Var.alloc((String)"_c_");
        if (query.isConstructType()) {
            Element element = query.getQueryPattern();
            query = new Query();
            query.setQuerySelectType();
            query.setQueryResultStar(true);
            query.setQueryPattern(element);
        }
        Query countQuery = QueryFactory.create((String)("Select (Count(*) As ?_c_) { {" + String.valueOf(query) + "} }"), (Syntax)Syntax.syntaxSPARQL_11);
        QueryExecution qe = qef.createQueryExecution(countQuery);
        ResultSet rs = qe.execSelect();
        Binding binding = rs.nextBinding();
        Node node = binding.get(outputVar);
        Number numeric = (Number)node.getLiteralValue();
        long result = numeric.longValue();
        return result;
    }

    public static Var extractProjectVar(Query query) {
        List vars = query.getProjectVars();
        if (vars.size() != 1) {
            throw new RuntimeException("Exactly 1 var expected");
        }
        Var result = (Var)vars.get(0);
        return result;
    }

    public static Node executeSingle(QueryExecutionFactory qef, Query query) {
        Var var = QueryExecutionUtils.extractProjectVar(query);
        Node result = QueryExecutionUtils.executeSingle(qef, query, var);
        return result;
    }

    public static Node executeSingle(QueryExecutionFactory qef, Query query, Var var) {
        Node result = null;
        try (QueryExecution qe = qef.createQueryExecution(query);){
            ResultSet rs = qe.execSelect();
            if (rs.hasNext()) {
                Binding binding = rs.nextBinding();
                result = binding.get(var);
            }
            if (rs.hasNext()) {
                logger.warn("A single result was retrieved, but more results exist - is this intended?");
            }
        }
        return result;
    }

    public static List<Node> executeList(QueryExecutionFactory qef, Query query) {
        Var var = QueryExecutionUtils.extractProjectVar(query);
        List<Node> result = QueryExecutionUtils.executeList(qef, query, var);
        return result;
    }

    public static List<Node> executeList(QueryExecutionFactory qef, Query query, Var var) {
        ArrayList<Node> result = new ArrayList<Node>();
        try (QueryExecution qe = qef.createQueryExecution(query);){
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                Binding binding = rs.nextBinding();
                Node node = binding.get(var);
                result.add(node);
            }
        }
        return result;
    }
}

