/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.staging;

import java.io.Closeable;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.aksw.commons.util.closeable.AutoCloseables;
import org.aksw.jena_sparql_api.cache.extra.InputStreamProvider;

public class InputStreamProviderBlobClosable
implements InputStreamProvider {
    private Closeable closable;
    private Blob blob;

    public InputStreamProviderBlobClosable(Blob blob, Closeable closable) {
        this.blob = blob;
        this.closable = closable;
    }

    @Override
    public InputStream open() {
        try {
            return this.blob.getBinaryStream();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        AutoCloseables.close((AutoCloseable)this.closable);
    }
}

