/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.transform.result_set;

import java.util.Iterator;
import java.util.List;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.aksw.jenax.arq.util.quad.DatasetGraphUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.dataaccess.sparql.execution.query.QueryExecutionWrapperBase;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetCloseable;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.jena.vocabulary.RDF;

public class QueryExecutionTransformResult
extends QueryExecutionWrapperBase<QueryExecution> {
    protected NodeTransform nodeTransform;

    public QueryExecutionTransformResult(QueryExecution decoratee, NodeTransform nodeTransform) {
        super(decoratee);
        this.nodeTransform = nodeTransform;
    }

    public ResultSet execSelect() {
        ResultSet core = super.execSelect();
        ResultSet result = QueryExecutionTransformResult.applyNodeTransform(this.nodeTransform, core, (QueryExecution)this);
        return result;
    }

    public Model execConstruct() {
        Model model = super.execConstruct();
        Model result = NodeTransformLib2.copyWithNodeTransform((NodeTransform)this.nodeTransform, (Model)model);
        return result;
    }

    public Model execConstruct(Model model) {
        Model tmp = this.execConstruct();
        model.add(tmp);
        return model;
    }

    public Iterator<Triple> execConstructTriples() {
        Iterator core = super.execConstructTriples();
        ExtendedIterator result = WrappedIterator.create((Iterator)Iter.onClose((Iterator)core, () -> ((QueryExecutionTransformResult)this).close())).mapWith(t -> NodeTransformLib.transform((NodeTransform)this.nodeTransform, (Triple)t));
        return result;
    }

    public Dataset execConstructDataset() {
        Dataset dataset = super.execConstructDataset();
        Dataset result = NodeTransformLib2.applyNodeTransform((NodeTransform)this.nodeTransform, (Dataset)dataset);
        return result;
    }

    public Dataset execConstructDataset(Dataset dataset) {
        Dataset tmp = this.execConstructDataset();
        DatasetGraphUtils.addAll((DatasetGraph)dataset.asDatasetGraph(), (DatasetGraph)tmp.asDatasetGraph());
        return dataset;
    }

    public Model execDescribe() {
        Model model = super.execConstruct();
        Model result = NodeTransformLib2.copyWithNodeTransform((NodeTransform)this.nodeTransform, (Model)model);
        return result;
    }

    public Model execDescribe(Model model) {
        Model tmp = this.execDescribe();
        model.add(tmp);
        return model;
    }

    public Iterator<Triple> execDescribeTriples() {
        Iterator core = super.execDescribeTriples();
        ExtendedIterator result = WrappedIterator.create((Iterator)Iter.onClose((Iterator)core, () -> ((QueryExecutionTransformResult)this).close())).mapWith(t -> NodeTransformLib.transform((NodeTransform)this.nodeTransform, (Triple)t));
        return result;
    }

    public static ResultSet applyNodeTransform(NodeTransform nodeTransform, ResultSet rs, QueryExecution qe) {
        List vars = rs.getResultVars();
        ExtendedIterator it = WrappedIterator.create((Iterator)RowSet.adapt((ResultSet)rs)).mapWith(b -> NodeTransformLib2.transformValues((Binding)b, (NodeTransform)nodeTransform));
        QueryIterator queryIter = QueryIterPlainWrapper.create((Iterator)it);
        ResultSet core = ResultSetFactory.create((QueryIterator)queryIter, (List)vars);
        ResultSetCloseable result = new ResultSetCloseable(core, qe);
        return result;
    }

    public static void main(String[] args) {
        Model model = ModelFactory.createDefaultModel();
        Node bn = NodeFactory.createBlankNode((String)"test");
        model.add(model.wrapAsResource(bn), RDF.type, (RDFNode)RDF.Property);
        NodeTransform nodeTransform = NodeTransformLib2.createBnodeLabelTransform((Expr)ExprUtils.parse((String)"CONCAT('_:', ?x )"), (Var)Vars.x);
        try (QueryExecutionTransformResult qe = new QueryExecutionTransformResult(QueryExecutionFactory.create((String)"SELECT * { ?s ?p ?o }", (Model)model), nodeTransform);){
            System.out.println(ResultSetFormatter.asText((ResultSet)qe.execSelect()));
        }
    }
}

