/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import java.util.Set;
import java.util.function.Function;
import org.aksw.commons.rx.lookup.MapService;
import org.aksw.commons.rx.lookup.MapServiceTransformItem;
import org.aksw.jena_sparql_api.lookup.MapServiceSparqlQuery;
import org.aksw.jenax.analytics.core.MappedConcept;
import org.aksw.jenax.analytics.core.MappedQuery;
import org.aksw.jenax.arq.aggregation.Agg;
import org.aksw.jenax.arq.aggregation.FunctionResultSetAggregate;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.aksw.jenax.sparql.relation.query.PartitionedQuery1;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;

public class MapServiceUtils {
    public static <T> MapService<Fragment1, Node, T> createListServiceMappedQuery(QueryExecutionFactoryQuery qef, MappedQuery<T> mappedQuery, boolean isLeftJoin) {
        MapService<Fragment1, Node, T> result = MapServiceUtils.createListServiceAcc(qef, mappedQuery, isLeftJoin);
        return result;
    }

    public static <T> MapService<Fragment1, Node, T> createListServiceAcc(QueryExecutionFactoryQuery qef, MappedQuery<T> mappedQuery, boolean isLeftJoin) {
        PartitionedQuery1 partQuery = mappedQuery.getPartQuery();
        Query query = partQuery.getQuery();
        Var partVar = partQuery.getPartitionVar();
        Agg agg = mappedQuery.getAgg();
        if (query.isSelectType()) {
            Set vars = agg.getDeclaredVars();
            if (vars == null) {
                query.setQueryResultStar(true);
            } else {
                for (Var var : vars) {
                    if (query.getProject().contains(var)) continue;
                    query.getProject().add(var);
                }
            }
        }
        MapServiceSparqlQuery ls = new MapServiceSparqlQuery(qef, query, partVar, isLeftJoin);
        FunctionResultSetAggregate fn = new FunctionResultSetAggregate(agg);
        MapServiceTransformItem result = MapServiceTransformItem.create((MapService)ls, (Function)fn);
        return result;
    }

    public static <T> MapService<Fragment1, Node, T> createListServiceAcc(QueryExecutionFactoryQuery qef, MappedConcept<T> mappedConcept, boolean isLeftJoin) {
        Concept concept = mappedConcept.getConcept();
        Query query = ConceptUtils.createQueryList((Fragment1)concept);
        Agg agg = mappedConcept.getAggregator();
        Set vars = agg.getDeclaredVars();
        for (Var var : vars) {
            query.getProject().add(var);
        }
        MapServiceSparqlQuery ls = new MapServiceSparqlQuery(qef, query, concept.getVar(), isLeftJoin);
        FunctionResultSetAggregate fn = new FunctionResultSetAggregate(agg);
        MapServiceTransformItem result = MapServiceTransformItem.create((MapService)ls, (Function)fn);
        return result;
    }

    public static <T> MapService<Fragment1, Node, T> createListServiceMappedConcept(QueryExecutionFactoryQuery qef, MappedConcept<T> mappedConcept, boolean isLeftJoin) {
        MapService<Fragment1, Node, T> result = MapServiceUtils.createListServiceAcc(qef, mappedConcept, isLeftJoin);
        return result;
    }
}

