/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.aksw.commons.collections.SetUtils;
import org.aksw.jena_sparql_api.core.ConstructIterator;
import org.aksw.jena_sparql_api.core.Describer;
import org.aksw.jena_sparql_api.core.IteratorWrapperClose;
import org.aksw.jenax.arq.util.quad.QuadPatternUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.dataaccess.sparql.execution.query.QueryExecutionWrapperBase;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetCloseable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryExecutionBaseSelect
extends QueryExecutionWrapperBase<QueryExecution>
implements QueryExecution {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionBaseSelect.class);
    protected Query query;
    protected QueryExecutionFactory parentFactory;

    public static Model createModel(Iterator<Triple> it) {
        return QueryExecutionBaseSelect.createModel(ModelFactory.createDefaultModel(), it);
    }

    public static Model createModel(Model result, Iterator<Triple> it) {
        while (it.hasNext()) {
            Triple t = it.next();
            Statement stmt = ModelUtils.tripleToStatement((Model)result, (Triple)t);
            if (stmt == null) continue;
            result.add(stmt);
        }
        return result;
    }

    public QueryExecutionBaseSelect(Query query, QueryExecutionFactory subFactory) {
        super(null);
        this.query = query;
        this.parentFactory = subFactory;
    }

    protected abstract QueryExecution executeCoreSelectX(Query var1);

    protected ResultSetCloseable executeCoreSelect(Query query) {
        if (this.decoratee != null) {
            throw new RuntimeException("A query is already running");
        }
        this.decoratee = this.executeCoreSelectX(query);
        if (this.decoratee == null) {
            throw new RuntimeException("Failed to obtain a QueryExecution for query: " + String.valueOf(query));
        }
        ResultSet tmp = this.decoratee.execSelect();
        QueryExecutionBaseSelect self = this;
        ResultSetCloseable result = new ResultSetCloseable(tmp, (QueryExecution)self);
        return result;
    }

    public boolean execAsk() {
        if (!this.query.isAskType()) {
            throw new RuntimeException("ASK query expected. Got: [" + this.query.toString() + "]");
        }
        Query selectQuery = QueryUtils.elementToQuery((Element)this.query.getQueryPattern());
        selectQuery.setLimit(1L);
        ResultSetCloseable rs = this.executeCoreSelect(selectQuery);
        long rowCount = 0L;
        while (rs.hasNext()) {
            rs.next();
            ++rowCount;
        }
        if (rowCount > 1L) {
            logger.warn("Received " + rowCount + " rows for the query [" + this.query.toString() + "]");
        }
        return rowCount > 0L;
    }

    public Model execDescribe() {
        Model model = ModelFactory.createDefaultModel();
        return this.execDescribe(model);
    }

    public static Node extractDescribeNode(Query query) {
        if (!query.isDescribeType()) {
            throw new RuntimeException("DESCRIBE query expected. Got: [" + query.toString() + "]");
        }
        if (query.getQueryPattern() != null || !query.getResultVars().isEmpty() || query.getResultURIs().size() > 1) {
            throw new RuntimeException("Sorry, DESCRIBE is only implemented for a single resource argument");
        }
        Node result = (Node)query.getResultURIs().get(0);
        return result;
    }

    public Iterator<Triple> execDescribeTriples() {
        ResultSetCloseable rs = null;
        if (this.query.getQueryPattern() != null) {
            Query q = new Query();
            q.setQuerySelectType();
            q.setResultVars();
            for (String v : this.query.getResultVars()) {
                q.addResultVar(v);
            }
            q.setQueryPattern(this.query.getQueryPattern());
            rs = this.executeCoreSelect(q);
        }
        Describer tmp = Describer.create(this.query.getResultURIs(), this.query.getResultVars(), rs, this.parentFactory);
        final QueryExecutionBaseSelect self = this;
        IteratorWrapperClose<Triple> result = new IteratorWrapperClose<Triple>((Iterator)((Object)tmp)){

            public void close() {
                self.close();
            }
        };
        return result;
    }

    public Model execDescribe(Model result) {
        QueryExecutionBaseSelect.createModel(result, this.execDescribeTriples());
        return result;
    }

    protected Iterator<Triple> executeConstructStreaming(Query query) {
        if (!query.isConstructType()) {
            throw new RuntimeException("CONSTRUCT query expected. Got: [" + query.toString() + "]");
        }
        Template template = query.getConstructTemplate();
        Set projectVars = QuadPatternUtils.getVarsMentioned((Iterable)template.getQuads());
        Query clone = query.cloneQuery();
        clone.setQuerySelectType();
        clone.getProject().clear();
        if (projectVars.isEmpty()) {
            Set patternVars = SetUtils.asSet((Iterable)PatternVars.vars((Element)query.getQueryPattern()));
            if (patternVars.isEmpty()) {
                clone.setQueryResultStar(true);
            } else {
                Var v = (Var)patternVars.iterator().next();
                clone.setQueryResultStar(false);
                clone.getProject().add(v);
            }
        } else {
            clone.setQueryResultStar(false);
            clone.addProjectVars((Collection)projectVars);
        }
        ResultSetCloseable rs = this.executeCoreSelect(clone);
        ConstructIterator result = new ConstructIterator(template, (ResultSet)rs);
        return result;
    }

    public Model execConstruct(Model result) {
        return QueryExecutionBaseSelect.createModel(result, this.execConstructTriples());
    }

    public Model execConstruct() {
        Model result = ModelFactory.createDefaultModel();
        this.execConstruct(result);
        return result;
    }

    public Iterator<Triple> execConstructTriples() {
        return this.executeConstructStreaming(this.query);
    }

    public ResultSet execSelect() {
        if (!this.query.isSelectType()) {
            throw new RuntimeException("SELECT query expected. Got: [" + this.query.toString() + "]");
        }
        return this.executeCoreSelect(this.query);
    }

    public Query getQuery() {
        return this.query;
    }

    public void executeUpdate(UpdateRequest updateRequest) {
        throw new RuntimeException("Not implemented");
    }

    public JsonArray execJson() {
        throw new UnsupportedOperationException();
    }

    public Iterator<JsonObject> execJsonItems() {
        throw new UnsupportedOperationException();
    }
}

