/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.aksw.jena_sparql_api.core.FluentBase;
import org.aksw.jena_sparql_api.core.FluentQueryExecutionFactoryFn;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryBase;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryDatasetGraph;
import org.aksw.jena_sparql_api.core.SparqlServiceReference;
import org.aksw.jena_sparql_api.core.utils.GraphResource;
import org.aksw.jena_sparql_api.fail.QueryExecutionFactoryAlwaysFail;
import org.aksw.jena_sparql_api.fallback.QueryExecutionFactoryFallback;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.model.QueryExecutionFactoryModel;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryDataset;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.util.Context;

public class FluentQueryExecutionFactory<P>
extends FluentBase<QueryExecutionFactory, P> {
    public FluentQueryExecutionFactory(QueryExecutionFactory qef) {
        this.fn = qef;
    }

    @Deprecated
    public static FluentQueryExecutionFactory<?> model(Model model) {
        return new FluentQueryExecutionFactory(new QueryExecutionFactoryModel(model));
    }

    @Deprecated
    public static FluentQueryExecutionFactory<?> model(Model model, Context context) {
        Dataset dataset = DatasetFactory.create((Model)model);
        return FluentQueryExecutionFactory.from(dataset, context);
    }

    public static FluentQueryExecutionFactory<?> alwaysFail(String serviceUrl) {
        return FluentQueryExecutionFactory.alwaysFail(serviceUrl, new DatasetDescription());
    }

    public static FluentQueryExecutionFactory<?> alwaysFail(String serviceUrl, String ... defaultGraphs) {
        DatasetDescription dd = new DatasetDescription();
        dd.addAllDefaultGraphURIs(Arrays.asList(defaultGraphs));
        return FluentQueryExecutionFactory.alwaysFail(serviceUrl, dd);
    }

    public static FluentQueryExecutionFactory<?> alwaysFail(String serviceUrl, DatasetDescription datasetDescription) {
        return new FluentQueryExecutionFactory(new QueryExecutionFactoryAlwaysFail(serviceUrl, datasetDescription));
    }

    public static FluentQueryExecutionFactory<?> from(Model model) {
        return new FluentQueryExecutionFactory(new QueryExecutionFactoryModel(model));
    }

    public static FluentQueryExecutionFactory<?> from(QueryExecutionFactory qef) {
        return new FluentQueryExecutionFactory(qef);
    }

    public static FluentQueryExecutionFactory<?> from(Model model, Context context) {
        Dataset dataset = DatasetFactory.create((Model)model);
        return FluentQueryExecutionFactory.from(dataset, context);
    }

    public static FluentQueryExecutionFactory<?> from(Graph graph) {
        return FluentQueryExecutionFactory.from(ModelFactory.createModelForGraph((Graph)graph));
    }

    public static FluentQueryExecutionFactory<?> fromFileNameOrUrl(String fileNameOrUrl) {
        GraphResource graph = new GraphResource(fileNameOrUrl);
        return FluentQueryExecutionFactory.from((Graph)graph);
    }

    public static FluentQueryExecutionFactory<?> from(Dataset dataset) {
        return FluentQueryExecutionFactory.from(dataset, null);
    }

    public static FluentQueryExecutionFactory<?> from(Dataset dataset, Context context) {
        return new FluentQueryExecutionFactory((QueryExecutionFactory)new QueryExecutionFactoryDataset(dataset, context));
    }

    public static FluentQueryExecutionFactory<?> from(DatasetGraph datasetGraph, Context context) {
        Dataset dataset = DatasetImpl.wrap((DatasetGraph)datasetGraph);
        return FluentQueryExecutionFactory.from(dataset, context);
    }

    public static FluentQueryExecutionFactory<?> defaultDatasetGraph() {
        return FluentQueryExecutionFactory.from(DatasetGraphFactory.createGeneral());
    }

    public static FluentQueryExecutionFactory<?> from(DatasetGraph datasetGraph) {
        return new FluentQueryExecutionFactory(new QueryExecutionFactoryDatasetGraph(datasetGraph, false));
    }

    public static FluentQueryExecutionFactory<?> from(final QueryExecutionFactoryQuery qefq) {
        return new FluentQueryExecutionFactory(new QueryExecutionFactoryBase(){

            public QueryExecution createQueryExecution(Query query) {
                return qefq.createQueryExecution(query);
            }

            public QueryExecution createQueryExecution(String queryString) {
                throw new RuntimeException("Cannot handle query as string. Wrap with a parser.");
            }

            public String getState() {
                return "";
            }

            public String getId() {
                return "";
            }
        });
    }

    public static FluentQueryExecutionFactory<?> http(String service, String ... defaultGraphs) {
        return FluentQueryExecutionFactory.http(service, Arrays.asList(defaultGraphs));
    }

    public static FluentQueryExecutionFactory<?> http(String service, Collection<String> defaultGraphs) {
        return new FluentQueryExecutionFactory(new QueryExecutionFactoryHttp(service, defaultGraphs));
    }

    public static FluentQueryExecutionFactory<?> http(SparqlServiceReference sparqlService) {
        return FluentQueryExecutionFactory.http(sparqlService.getServiceURL(), sparqlService.getDefaultGraphURIs());
    }

    public static FluentQueryExecutionFactory<?> http(Collection<SparqlServiceReference> sparqlServices) {
        if (sparqlServices.size() == 1) {
            return FluentQueryExecutionFactory.http(sparqlServices.iterator().next());
        }
        ArrayList<QueryExecutionFactory> decoratees = new ArrayList<QueryExecutionFactory>(sparqlServices.size());
        for (SparqlServiceReference sparqlService : sparqlServices) {
            decoratees.add(new QueryExecutionFactoryHttp(sparqlService.getServiceURL(), sparqlService.getDefaultGraphURIs()));
        }
        return new FluentQueryExecutionFactory(new QueryExecutionFactoryFallback(decoratees));
    }

    public FluentQueryExecutionFactoryFn<FluentQueryExecutionFactory<P>> config() {
        final FluentQueryExecutionFactory self = this;
        final FluentQueryExecutionFactoryFn<FluentQueryExecutionFactory<P>> result = new FluentQueryExecutionFactoryFn<FluentQueryExecutionFactory<P>>();
        result.setParentSupplier(new Supplier<FluentQueryExecutionFactory<P>>(){

            public FluentQueryExecutionFactory<P> get() {
                Object transform = result.value();
                FluentQueryExecutionFactory.this.fn = transform.apply((QueryExecutionFactory)FluentQueryExecutionFactory.this.fn);
                return self;
            }
        });
        return result;
    }
}

