/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.staging;

import java.io.IOException;
import org.aksw.commons.util.closeable.AutoCloseables;
import org.aksw.jena_sparql_api.cache.core.ModelProvider;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.extra.CacheResource;
import org.aksw.jenax.dataaccess.sparql.execution.query.QueryExecutionWrapperBase;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionCacheFrontend
extends QueryExecutionWrapperBase<QueryExecution> {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionCacheFrontend.class);
    private CacheFrontend cacheFrontend;
    private String service;
    private String queryString;
    private CacheResource resource;

    public QueryExecutionCacheFrontend(QueryExecution decoratee, String service, String queryString, CacheFrontend cacheFrontend) {
        super(decoratee);
        this.service = service;
        this.queryString = queryString;
        this.cacheFrontend = cacheFrontend;
    }

    private void setResource(CacheResource resource) {
        if (this.resource != null) {
            AutoCloseables.close((AutoCloseable)this.resource);
            if (resource != null) {
                AutoCloseables.close((AutoCloseable)resource);
            }
        }
        this.resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet doCacheResultSet() {
        QueryExecutionCacheFrontend queryExecutionCacheFrontend = this;
        synchronized (queryExecutionCacheFrontend) {
            this.resource = this.cacheFrontend.lookup(this.service, this.queryString);
            this.setResource(this.resource);
        }
        if (this.resource == null || this.resource.isOutdated()) {
            ResultSet rs;
            AutoCloseables.close((AutoCloseable)this.resource);
            try {
                rs = this.getDelegate().execSelect();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!this.cacheFrontend.isReadOnly()) {
                logger.trace("Cache write [" + this.service + "]: " + this.queryString);
                this.cacheFrontend.write(this.service, this.queryString, rs);
                QueryExecutionCacheFrontend queryExecutionCacheFrontend2 = this;
                synchronized (queryExecutionCacheFrontend2) {
                    this.resource = this.cacheFrontend.lookup(this.service, this.queryString);
                    this.setResource(this.resource);
                }
                if (this.resource == null) {
                    throw new RuntimeException("Cache error: Lookup of just written data failed");
                }
            }
        } else {
            logger.trace("Cache hit [" + this.service + "]:" + this.queryString);
        }
        return this.resource.asResultSet();
    }

    public synchronized Model doCacheModel(Model result, ModelProvider modelProvider) {
        try {
            return this._doCacheModel(result, modelProvider);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Model _doCacheModel(Model result, ModelProvider modelProvider) throws IOException {
        QueryExecutionCacheFrontend queryExecutionCacheFrontend = this;
        synchronized (queryExecutionCacheFrontend) {
            this.resource = this.cacheFrontend.lookup(this.service, this.queryString);
            this.setResource(this.resource);
        }
        if (this.resource == null || this.resource.isOutdated()) {
            Model model;
            try {
                model = modelProvider.getModel();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.trace("Cache write [" + this.service + "]: " + this.queryString);
            this.cacheFrontend.write(this.service, this.queryString, model);
            QueryExecutionCacheFrontend queryExecutionCacheFrontend2 = this;
            synchronized (queryExecutionCacheFrontend2) {
                this.resource = this.cacheFrontend.lookup(this.service, this.queryString);
                this.setResource(this.resource);
            }
            if (this.resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit [" + this.service + "]:" + this.queryString);
        }
        return this.resource.asModel(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean doCacheBoolean() {
        QueryExecutionCacheFrontend queryExecutionCacheFrontend = this;
        synchronized (queryExecutionCacheFrontend) {
            this.resource = this.cacheFrontend.lookup(this.service, this.queryString);
            this.setResource(this.resource);
        }
        if (this.resource == null || this.resource.isOutdated()) {
            boolean ret;
            try {
                ret = this.getDelegate().execAsk();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.trace("Cache write [" + this.service + "]: " + this.queryString);
            this.cacheFrontend.write(this.service, this.queryString, ret);
            QueryExecutionCacheFrontend queryExecutionCacheFrontend2 = this;
            synchronized (queryExecutionCacheFrontend2) {
                this.resource = this.cacheFrontend.lookup(this.service, this.queryString);
                this.setResource(this.resource);
            }
            if (this.resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit [" + this.service + "]:" + this.queryString);
        }
        return this.resource.asBoolean();
    }

    public ResultSet execSelect() {
        return this.doCacheResultSet();
    }

    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    public Model execConstruct(Model model) {
        return this.doCacheModel(model, new ModelProvider(){

            @Override
            public Model getModel() {
                return QueryExecutionCacheFrontend.this.getDelegate().execConstruct();
            }
        });
    }

    public Model execDescribe() {
        return this.execDescribe(ModelFactory.createDefaultModel());
    }

    public Model execDescribe(Model model) {
        return this.doCacheModel(model, new ModelProvider(){

            @Override
            public Model getModel() {
                return QueryExecutionCacheFrontend.this.getDelegate().execDescribe();
            }
        });
    }

    public boolean execAsk() {
        return this.doCacheBoolean();
    }

    public void abort() {
        AutoCloseables.close((AutoCloseable)this.resource);
        super.abort();
    }
}

