/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.rx.lookup.LookupService;
import org.aksw.jenax.arq.dataset.api.DatasetGraphOneNg;
import org.aksw.jenax.arq.dataset.api.DatasetOneNg;
import org.aksw.jenax.arq.dataset.impl.DatasetGraphOneNgImpl;
import org.aksw.jenax.arq.dataset.impl.DatasetOneNgImpl;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;

public class LookupServiceSparqlConstructQuads
implements LookupService<Node, DatasetOneNg> {
    private QueryExecutionFactoryQuery qef;
    private Query query;
    private Var var;

    public LookupServiceSparqlConstructQuads(QueryExecutionFactoryQuery qef, Query query) {
        Preconditions.checkArgument((boolean)query.isConstructQuad(), (Object)"Query must be constructQuad type.");
        this.qef = qef;
        this.query = query;
        Set graphs = query.getConstructTemplate().getQuads().stream().map(Quad::getGraph).collect(Collectors.toSet());
        Preconditions.checkArgument((graphs.size() == 1 ? 1 : 0) != 0, (Object)"Construct template must produce exactly one graph");
        Node graphNode = (Node)graphs.iterator().next();
        Preconditions.checkArgument((boolean)graphNode.isVariable(), (Object)"Graph must be a variable");
        this.var = (Var)graphNode;
    }

    public Flowable<Map.Entry<Node, DatasetOneNg>> apply(Iterable<Node> keys) {
        Flowable result;
        if (!Iterables.isEmpty(keys)) {
            ExprList exprs = new ExprList();
            for (Node key : keys) {
                NodeValue e = NodeValue.makeNode((Node)key);
                exprs.add((Expr)e);
            }
            E_OneOf expr = new E_OneOf((Expr)new ExprVar(this.var), exprs);
            ElementFilter filterElement = new ElementFilter((Expr)expr);
            Query q = this.query.cloneQuery();
            Element newElement = ElementUtils.mergeElements((Element)q.getQueryPattern(), (Element)filterElement);
            q.setQueryPattern(newElement);
            result = SparqlRx.execConstructQuads(() -> this.qef.createQueryExecution(q)).groupBy(t -> t.getGraph()).flatMapSingle(groups -> groups.collectInto((Object)GraphFactory.createDefaultGraph(), (g, quad) -> g.add(quad.asTriple())).map(x -> Maps.immutableEntry((Object)((Node)groups.getKey()), (Object)DatasetOneNgImpl.wrap((DatasetGraphOneNg)DatasetGraphOneNgImpl.create((Node)((Node)groups.getKey()), (Graph)x)))));
        } else {
            result = Flowable.empty();
        }
        return result;
    }
}

