/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.delay.extra;

import org.aksw.jena_sparql_api.delay.extra.Delayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DelayerBase
implements Delayer {
    private static Logger logger = LoggerFactory.getLogger(DelayerBase.class);

    public abstract long getDelay();

    public abstract long getLastRequestTime();

    public abstract void setLastRequestTime(long var1);

    @Override
    public synchronized void doDelay() throws InterruptedException {
        long remainingDelay = this.computeRemainingDelayInMs();
        if (remainingDelay > 0L) {
            logger.debug("Delaying by " + remainingDelay + "ms.");
            Thread.sleep(remainingDelay);
        }
        this.setLastRequestTime(System.currentTimeMillis());
    }

    public long computeRemainingDelayInMs() {
        long now = System.currentTimeMillis();
        long tmp = this.getDelay() - (now - this.getLastRequestTime());
        long result = Math.max(0L, tmp);
        return result;
    }

    public String toString() {
        return "Delayer with " + this.computeRemainingDelayInMs() + "ms remaining";
    }
}

