/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.compare;

import org.aksw.jena_sparql_api.compare.QueryExecutionCompare;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryBackQuery;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;

public class QueryExecutionFactoryCompare
extends QueryExecutionFactoryBackQuery {
    private QueryExecutionFactory a;
    private QueryExecutionFactory b;
    private boolean removeSlices = false;

    public QueryExecutionFactoryCompare(QueryExecutionFactory a, QueryExecutionFactory b) {
        this(a, b, false);
    }

    public QueryExecutionFactoryCompare(QueryExecutionFactory a, QueryExecutionFactory b, boolean removesSlices) {
        this.a = a;
        this.b = b;
        this.removeSlices = removesSlices;
    }

    public QueryExecutionCompare createQueryExecution(Query query) {
        if (this.removeSlices) {
            query = (Query)query.clone();
            query.setLimit(Long.MIN_VALUE);
            query.setOffset(Long.MIN_VALUE);
        }
        QueryExecution qea = this.a.createQueryExecution(query);
        QueryExecution qeb = this.b.createQueryExecution(query);
        QueryExecutionCompare result = new QueryExecutionCompare(query, qea, qeb, false);
        return result;
    }

    @Override
    public QueryExecutionCompare createQueryExecution(String queryString) {
        return (QueryExecutionCompare)super.createQueryExecution(queryString);
    }

    public String getId() {
        return "compare(" + this.a.getId() + ", " + this.b.getId() + ")";
    }

    public String getState() {
        return null;
    }
}

