/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core.utils;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aksw.commons.util.range.CountInfo;
import org.aksw.jena_sparql_api.core.utils.ResultSetUtils;
import org.aksw.jenax.arq.util.syntax.QueryGenerationUtils;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.aksw.jenax.sparql.fragment.impl.OrderedConcept;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.core.Var;

public class ServiceUtils {
    public static List<Resource> fetchListResources(SparqlQueryConnection qef, Concept concept) {
        List<Node> tmp = ServiceUtils.fetchList(qef, (Fragment1)concept);
        ArrayList<Resource> result = new ArrayList<Resource>(tmp.size());
        for (Node node : tmp) {
            Resource resource = ResourceFactory.createResource((String)node.getURI());
            result.add(resource);
        }
        return result;
    }

    public static List<Node> fetchList(SparqlQueryConnection qef, OrderedConcept orderedConcept, Long limit, Long offset) {
        Query query = ConceptUtils.createQueryList((OrderedConcept)orderedConcept, (Long)limit, (Long)offset);
        List<Node> result = ServiceUtils.fetchList(qef, query, orderedConcept.getConcept().getVar());
        return result;
    }

    public static List<Node> fetchList(SparqlQueryConnection qef, Fragment1 concept, Long limit, Long offset) {
        Query query = ConceptUtils.createQueryList((Fragment1)concept, (Long)limit, (Long)offset);
        List<Node> result = ServiceUtils.fetchList(qef, query, concept.getVar());
        return result;
    }

    public static List<Node> fetchList(SparqlQueryConnection qef, Fragment1 concept) {
        Query query = ConceptUtils.createQueryList((Fragment1)concept);
        List<Node> result = ServiceUtils.fetchList(qef, query, concept.getVar());
        return result;
    }

    public static List<Node> fetchList(SparqlQueryConnection qef, Query query, Var v) {
        QueryExecution qe = qef.query(query);
        List<Node> result = ServiceUtils.fetchList(qe, v);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Node> fetchList(QueryExecution qe, Var v) {
        try {
            List result;
            ResultSet rs = qe.execSelect();
            List list = result = org.aksw.jenax.arq.util.binding.ResultSetUtils.resultSetToList((ResultSet)rs, (Var)v);
            return list;
        }
        finally {
            qe.close();
        }
    }

    public static Integer fetchInteger(QueryExecutionFactoryQuery qef, Query query, Var v) {
        QueryExecution qe = qef.createQueryExecution(query);
        Integer result = ServiceUtils.fetchInteger(qe, v);
        return result;
    }

    public static Integer fetchInteger(QueryExecution qe, Var v) {
        ResultSet rs = qe.execSelect();
        Integer result = org.aksw.jenax.arq.util.binding.ResultSetUtils.resultSetToInt((ResultSet)rs, (Var)v);
        return result;
    }

    public static Number fetchNumber(QueryExecution qe, Var v) {
        Number result;
        try (QueryExecution myQe = qe;){
            ResultSet rs = myQe.execSelect();
            RDFNode tmp = org.aksw.jenax.arq.util.binding.ResultSetUtils.getNextRDFNode((ResultSet)rs, (Var)v);
            if (tmp != null && tmp.isLiteral()) {
                Object val = tmp.asLiteral().getValue();
                if (val == null) {
                    result = null;
                } else {
                    if (!(val instanceof Number)) {
                        throw new RuntimeException("Value " + String.valueOf(val) + " is not a Number");
                    }
                    result = (Number)val;
                }
            } else {
                throw new RuntimeException("RDFNode " + String.valueOf(tmp) + " is not a literal");
            }
            if (rs.hasNext()) {
                throw new RuntimeException("At most one result set row expected");
            }
        }
        return result;
    }

    public static CountInfo fetchCountConcept(QueryExecutionFactory sparqlService, Concept concept, Long itemLimit, Long rowLimit) {
        Var outputVar = ConceptUtils.freshVar((Fragment1)concept);
        long xitemLimit = itemLimit == null ? null : Long.valueOf(itemLimit + 1L);
        long xrowLimit = rowLimit == null ? null : Long.valueOf(rowLimit + 1L);
        Query countQuery = ConceptUtils.createQueryCount((Fragment1)concept, (Var)outputVar, (Long)xitemLimit, (Long)xrowLimit);
        Integer count = ServiceUtils.fetchInteger((QueryExecutionFactoryQuery)sparqlService, countQuery, outputVar);
        boolean hasMoreItems = rowLimit != null ? null : Boolean.valueOf(itemLimit != null ? (long)count.intValue() > itemLimit : false);
        Long c = hasMoreItems ? itemLimit : (long)count.intValue();
        CountInfo result = new CountInfo(c.longValue(), hasMoreItems, itemLimit);
        return result;
    }

    public static Range<Long> fetchCountQuery(QueryExecutionFactoryQuery sparqlService, Query query, Long itemLimit, Long rowLimit) {
        Long xitemLimit = itemLimit == null ? null : Long.valueOf(itemLimit + 1L);
        Long xrowLimit = rowLimit == null ? null : Long.valueOf(rowLimit + 1L);
        Map.Entry e = QueryGenerationUtils.createQueryCount((Query)query, (Long)xitemLimit, (Long)xrowLimit);
        Var outputVar = (Var)e.getKey();
        Query countQuery = (Query)e.getValue();
        Integer count = ServiceUtils.fetchInteger(sparqlService, countQuery, outputVar);
        boolean hasMoreItems = rowLimit != null ? null : Boolean.valueOf(itemLimit != null ? (long)count.intValue() > itemLimit : false);
        Range result = hasMoreItems ? Range.atLeast((Comparable)itemLimit) : Range.singleton((Comparable)Long.valueOf(count.longValue()));
        return result;
    }

    public static ResultSet forceExecResultSet(QueryExecution qe, Query query) {
        ResultSet result;
        if (query.isSelectType()) {
            result = qe.execSelect();
        } else if (query.isConstructType()) {
            Iterator it = qe.execConstructTriples();
            result = ResultSetUtils.tripleIteratorToResultSet(it, qe);
        } else {
            throw new RuntimeException("Query type is not supported: " + String.valueOf(query));
        }
        return result;
    }
}

