/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import java.util.List;
import java.util.function.Function;
import org.aksw.commons.rx.lookup.LookupService;
import org.aksw.commons.rx.lookup.LookupServiceTransformValue;
import org.aksw.jena_sparql_api.lookup.LookupServiceSparqlQuery;
import org.aksw.jenax.analytics.core.MappedConcept;
import org.aksw.jenax.analytics.core.MappedQuery;
import org.aksw.jenax.arq.aggregation.Agg;
import org.aksw.jenax.arq.aggregation.AggList;
import org.aksw.jenax.arq.aggregation.AggLiteral;
import org.aksw.jenax.arq.aggregation.FunctionResultSetAggregate;
import org.aksw.jenax.arq.util.binding.BindingMapper;
import org.aksw.jenax.arq.util.binding.BindingMapperProjectVar;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.FragmentUtils;
import org.aksw.jenax.sparql.relation.query.PartitionedQuery1;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;

public class LookupServiceUtils {
    public static <T> LookupService<Node, List<Node>> createLookupService(QueryExecutionFactoryQuery qef, Fragment2 relation) {
        Var sourceVar = relation.getSourceVar();
        AggList agg = AggList.create((Agg)AggLiteral.create((BindingMapper)BindingMapperProjectVar.create((Var)relation.getTargetVar())));
        Query query = FragmentUtils.createQuery((Fragment)relation);
        MappedQuery mappedQuery = MappedQuery.create((Query)query, (Var)sourceVar, (Agg)agg);
        LookupService<Node, T> result = LookupServiceUtils.createLookupService(qef, mappedQuery);
        return result;
    }

    public static <T> LookupService<Node, T> createLookupService(QueryExecutionFactoryQuery sparqlService, MappedQuery<T> mappedQuery) {
        PartitionedQuery1 partQuery = mappedQuery.getPartQuery();
        Query query = partQuery.getQuery();
        Var partVar = partQuery.getPartitionVar();
        Agg agg = mappedQuery.getAgg();
        LookupServiceSparqlQuery base = new LookupServiceSparqlQuery(sparqlService, query, partVar);
        FunctionResultSetAggregate transform = FunctionResultSetAggregate.create((Agg)agg);
        LookupServiceTransformValue result = LookupServiceTransformValue.create((LookupService)base, (Function)transform);
        return result;
    }

    @Deprecated
    public static <T> LookupService<Node, T> createLookupService(QueryExecutionFactoryQuery sparqlService, MappedConcept<T> mappedConcept) {
        throw new RuntimeException("This method is broken. Use MapServiceResourceShape.createLookupService(qef, shape) instead)");
    }
}

