/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.update;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;

public class DiffQuadUtils {
    public static <K, V> Map<K, Diff<Set<V>>> mergeDiff(Map<K, Set<V>> added, Map<K, Set<V>> removed) {
        HashSet<K> graphs = new HashSet<K>();
        graphs.addAll(added.keySet());
        graphs.addAll(removed.keySet());
        HashMap result = new HashMap();
        for (Object graph : graphs) {
            HashSet sa = added.get(graph);
            HashSet sr = removed.get(graph);
            sa = sa == null ? new HashSet() : sa;
            sr = sr == null ? new HashSet() : sr;
            Diff item = Diff.create(sa, sr);
            result.put(graph, item);
        }
        return result;
    }

    public static Map<Node, Diff<Set<Triple>>> partitionQuads(Diff<? extends Iterable<Quad>> diff) {
        Map added = QuadUtils.partitionByGraphTriples((Iterable)((Iterable)diff.getAdded()));
        Map removed = QuadUtils.partitionByGraphTriples((Iterable)((Iterable)diff.getRemoved()));
        Map<Node, Diff<Set<Triple>>> result = DiffQuadUtils.mergeDiff(added, removed);
        return result;
    }

    public static Map<Node, Diff<Set<Quad>>> partitionQuadsByGraph(Diff<? extends Iterable<Quad>> diff) {
        Map added = QuadUtils.partitionByGraph((Iterable)((Iterable)diff.getAdded()));
        Map removed = QuadUtils.partitionByGraph((Iterable)((Iterable)diff.getRemoved()));
        Map<Node, Diff<Set<Quad>>> result = DiffQuadUtils.mergeDiff(added, removed);
        return result;
    }
}

