/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.pagination.core;

import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.PrefetchIterator;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetCloseable;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIteratorResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetPaginated
extends PrefetchIterator<Binding>
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetPaginated.class);
    protected QueryExecutionFactory serviceFactory;
    protected Iterator<Query> queryIterator;
    protected boolean stopOnEmptyResult = true;
    protected boolean stopIfLimitNotReached = true;
    protected ResultSet currentResultSet = null;
    protected QueryExecution currentExecution = null;
    protected List<String> currentResultVars = null;
    protected long lastExpectedResultSetSize = Long.MIN_VALUE;
    protected long lastSeenResultSetSize = 0L;
    protected long lastSeenRowNumber = -1L;

    public ResultSetPaginated(QueryExecutionFactory service, Iterator<Query> queryIterator, boolean stopOnEmptyResult, boolean stopIfLimitNotReached) {
        this.serviceFactory = service;
        this.queryIterator = queryIterator;
        this.stopOnEmptyResult = stopOnEmptyResult;
        this.stopIfLimitNotReached = stopIfLimitNotReached;
    }

    public ResultSet getCurrentResultSet() {
        return this.currentResultSet;
    }

    public List<String> getCurrentResultVars() {
        return this.currentResultVars;
    }

    protected QueryIteratorResultSet prefetch() throws Exception {
        QueryIteratorResultSet result = null;
        if (this.stopIfLimitNotReached && this.lastExpectedResultSetSize != Long.MIN_VALUE && this.currentResultSet != null && this.lastSeenRowNumber < this.lastExpectedResultSetSize) {
            result = null;
        } else {
            while (this.queryIterator.hasNext()) {
                Query query = this.queryIterator.next();
                if (query == null) {
                    throw new RuntimeException("Null query encountered in iterator");
                }
                this.lastExpectedResultSetSize = query.getLimit();
                QueryExecution qe = this.serviceFactory.createQueryExecution(query);
                logger.trace("Executing: " + String.valueOf(query));
                this.currentResultSet = qe.execSelect();
                this.currentResultVars = this.currentResultSet.getResultVars();
                this.currentResultSet = new ResultSetCloseable(this.currentResultSet, qe){

                    public void close() {
                        ResultSetPaginated.this.lastSeenRowNumber = this.getRowNumber();
                        super.close();
                    }
                };
                if (!this.currentResultSet.hasNext()) {
                    if (!this.stopOnEmptyResult) continue;
                    break;
                }
                result = new QueryIteratorResultSet(this.currentResultSet);
                break;
            }
        }
        return result;
    }

    public void close() {
        if (this.currentExecution != null) {
            this.currentExecution.close();
        }
    }
}

