package org.aksw.jena_sparql_api.core;

import java.util.Iterator;

import org.aksw.commons.collections.PrefetchIterator;
import com.google.common.collect.Iterators;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.modify.TemplateLib;
import org.apache.jena.sparql.syntax.Template;

/**
 * @author Claus Stadler
 *         <p/>
 *         Date: 11/5/11
 *         Time: 2:16 PM
 */
public class ConstructIterator
    extends PrefetchIterator<Triple>
{
    private Template template;
    private ResultSet rs;

    public ConstructIterator(Template template, ResultSet rs)
    {
        this.template = template;
        this.rs = rs;
    }


    /**
     * Returns an iterator over the triples generated by instancing the
     * template with each of the result set rows.
     *
     * Duplicates are not removed; this can be achieved by
     * wrapping this iterator with a UniqueIterator.
     *
     * TODO We could do some optimization by factoring out constant triples from the
     * template.
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Iterator<Triple> prefetch() throws Exception {

        // Build each template substitution as triples.
        while(rs.hasNext()) {
//            Set<Triple> set = new HashSet<Triple>();
//            Map<Node, Node> bNodeMap = new HashMap<Node, Node>();
            Binding binding = rs.nextBinding();
            // calcTriples ensures that only valid triples are emitted
            // i.e. literals in subject positions are discarded
            Iterator<Triple> r = TemplateLib.calcTriples(template.getTriples(), Iterators.singletonIterator(binding));
//            template.subst(set, bNodeMap, binding);

            return r;
        }

        return null;
    }

    @Override
    public void close() {
    	super.close();
    	//rs.close();
    }
}
