/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Map;
import org.aksw.commons.rx.lookup.LookupService;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;

public class LookupServiceSparqlConstruct
implements LookupService<Node, Model> {
    private QueryExecutionFactory qef;
    private Query query;
    private Var var;

    public LookupServiceSparqlConstruct(QueryExecutionFactory qef, Query query, Var var) {
        this.qef = qef;
        this.query = query;
        this.var = var;
    }

    public Flowable<Map.Entry<Node, Model>> apply(Iterable<Node> keys) {
        Flowable result;
        if (!Iterables.isEmpty(keys)) {
            ExprList exprs = new ExprList();
            for (Node key : keys) {
                NodeValue e = NodeValue.makeNode((Node)key);
                exprs.add((Expr)e);
            }
            E_OneOf expr = new E_OneOf((Expr)new ExprVar(this.var), exprs);
            ElementFilter filterElement = new ElementFilter((Expr)expr);
            Query q = this.query.cloneQuery();
            Element newElement = ElementUtils.mergeElements((Element)q.getQueryPattern(), (Element)filterElement);
            q.setQueryPattern(newElement);
            result = SparqlRx.execConstructTriples(() -> this.qef.createQueryExecution(q)).groupBy(t -> t.getSubject()).flatMapSingle(groups -> groups.collectInto((Object)GraphFactory.createDefaultGraph(), (g, t) -> g.add(t)).map(x -> Maps.immutableEntry((Object)((Node)groups.getKey()), (Object)ModelFactory.createModelForGraph((Graph)x))));
        } else {
            result = Flowable.empty();
        }
        return result;
    }
}

