/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import java.net.http.HttpClient;
import java.util.HashMap;
import java.util.Map;
import org.aksw.jena_sparql_api.cache.core.QueryExecutionFactoryCacheEx;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.core.SparqlServiceFactory;
import org.aksw.jena_sparql_api.core.SparqlServiceFactoryHttp;
import org.aksw.jena_sparql_api.core.SparqlServiceImpl;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.jenax.arq.util.dataset.DatasetDescriptionUtils;
import org.aksw.jenax.connectionless.SparqlService;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.apache.jena.sparql.core.DatasetDescription;

public class SparqlServiceFactoryImpl
implements SparqlServiceFactory {
    private Map<String, SparqlService> keyToSparqlService = new HashMap<String, SparqlService>();
    private CacheFrontend cacheFrontend;
    private SparqlServiceFactory delegate;
    private Integer pageSize;

    public SparqlServiceFactoryImpl(CacheFrontend cacheFrontend) {
        this(new SparqlServiceFactoryHttp(), cacheFrontend, null);
    }

    public SparqlServiceFactoryImpl(CacheFrontend cacheFrontend, Integer pageSize) {
        this(new SparqlServiceFactoryHttp(), cacheFrontend, pageSize);
    }

    public SparqlServiceFactoryImpl(Integer pageSize) {
        this(new SparqlServiceFactoryHttp(), null, pageSize);
    }

    public SparqlServiceFactoryImpl(SparqlServiceFactory delegate, CacheFrontend cacheFrontend, Integer pageSize) {
        this.delegate = delegate;
        this.cacheFrontend = cacheFrontend;
        this.pageSize = pageSize;
    }

    @Override
    public SparqlService createSparqlService(String serviceUri, DatasetDescription datasetDescription, HttpClient httpClient) {
        String str;
        String key;
        SparqlService result;
        if (datasetDescription == null) {
            datasetDescription = new DatasetDescription();
        }
        if ((result = this.keyToSparqlService.get(key = serviceUri + (str = DatasetDescriptionUtils.toString((DatasetDescription)datasetDescription)))) == null) {
            SparqlService tmp = this.delegate.createSparqlService(serviceUri, datasetDescription, httpClient);
            Object qef = tmp.getQueryExecutionFactory();
            if (this.cacheFrontend != null) {
                qef = new QueryExecutionFactoryCacheEx((QueryExecutionFactory)qef, this.cacheFrontend);
            }
            if (this.pageSize != null && this.pageSize >= 0) {
                qef = new QueryExecutionFactoryPaginated((QueryExecutionFactory)qef);
            }
            result = new SparqlServiceImpl((QueryExecutionFactory)qef, tmp.getUpdateExecutionFactory());
            this.keyToSparqlService.put(key, result);
        }
        return result;
    }
}

