/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.changeset;

import org.aksw.jena_sparql_api.changeset.ChangeSetMetadata;
import org.apache.jena.graph.Graph;

public class ChangeSet {
    private ChangeSetMetadata metadata;
    private String uri;
    private String precedingChangeSet;
    private String subjectOfChange;
    private Graph addition;
    private Graph removal;
    private String service;
    private String graph;

    public ChangeSet(ChangeSetMetadata metadata, String uri, String precedingChangeSet, String subjectOfChange, Graph addition, Graph removal) {
        this(metadata, uri, precedingChangeSet, subjectOfChange, addition, removal, null, null);
    }

    public ChangeSet(ChangeSetMetadata metadata, String uri, String precedingChangeSet, String subjectOfChange, Graph addition, Graph removal, String service, String graph) {
        this.metadata = metadata;
        this.uri = uri;
        this.precedingChangeSet = precedingChangeSet;
        this.subjectOfChange = subjectOfChange;
        this.addition = addition;
        this.removal = removal;
        this.service = service;
        this.graph = graph;
    }

    public String getUri() {
        return this.uri;
    }

    public String getSubjectOfChange() {
        return this.subjectOfChange;
    }

    public Graph getAddition() {
        return this.addition;
    }

    public Graph getRemoval() {
        return this.removal;
    }

    public ChangeSetMetadata getMetadata() {
        return this.metadata;
    }

    public String getPrecedingChangeSet() {
        return this.precedingChangeSet;
    }

    public String getService() {
        return this.service;
    }

    public String getGraph() {
        return this.graph;
    }

    public boolean isEmpty() {
        boolean result = this.addition.isEmpty() && this.removal.isEmpty();
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addition == null ? 0 : this.addition.hashCode());
        result = 31 * result + (this.graph == null ? 0 : this.graph.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.precedingChangeSet == null ? 0 : this.precedingChangeSet.hashCode());
        result = 31 * result + (this.removal == null ? 0 : this.removal.hashCode());
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        result = 31 * result + (this.subjectOfChange == null ? 0 : this.subjectOfChange.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeSet other = (ChangeSet)obj;
        if (this.addition == null ? other.addition != null : !this.addition.equals(other.addition)) {
            return false;
        }
        if (this.graph == null ? other.graph != null : !this.graph.equals(other.graph)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.precedingChangeSet == null ? other.precedingChangeSet != null : !this.precedingChangeSet.equals(other.precedingChangeSet)) {
            return false;
        }
        if (this.removal == null ? other.removal != null : !this.removal.equals(other.removal)) {
            return false;
        }
        if (this.service == null ? other.service != null : !this.service.equals(other.service)) {
            return false;
        }
        if (this.subjectOfChange == null ? other.subjectOfChange != null : !this.subjectOfChange.equals(other.subjectOfChange)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public String toString() {
        return "ChangeSet [metadata=" + String.valueOf(this.metadata) + ", uri=" + this.uri + ", precedingChangeSet=" + this.precedingChangeSet + ", subjectOfChange=" + this.subjectOfChange + ", addition=" + String.valueOf(this.addition) + ", removal=" + String.valueOf(this.removal) + ", service=" + this.service + ", graph=" + this.graph + "]";
    }
}

