/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.rx.lookup.LookupService;
import org.aksw.jena_sparql_api.core.LookupServiceUtils;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jenax.arq.aggregation.AccBestLiteral;
import org.aksw.jenax.arq.aggregation.BestLiteralConfig;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.prefix.PrefixUtils;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapAdapter;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.util.SplitIRI;
import org.apache.jena.vocabulary.RDFS;

public class LabelUtils {
    public static Node findBestLiteral(RDFNode rdfNode, BestLiteralConfig config) {
        Node result = null;
        AccBestLiteral acc = new AccBestLiteral(config);
        Node s = rdfNode.asNode();
        if (rdfNode.isResource()) {
            Resource r = rdfNode.asResource();
            List preds = config.getPredicates();
            if (preds == null) {
                preds = r.listProperties().mapWith(Statement::getObject).mapWith(FrontsNode::asNode).toList();
            }
            for (Node p : config.getPredicates()) {
                PropertyImpl prop = new PropertyImpl(p, (EnhGraph)null);
                List os = r.listProperties((Property)prop).mapWith(Statement::getObject).mapWith(FrontsNode::asNode).toList();
                for (Node o : os) {
                    Binding binding = BindingFactory.builder().add(config.getSubjectVar(), s).add(config.getPredicateVar(), p).add(config.getObjectVar(), o).build();
                    acc.accumulate(binding, null);
                }
            }
            result = Optional.ofNullable(acc.getValue()).map(NodeValue::asNode).orElse(null);
        }
        if (result == null) {
            result = s;
        }
        return result;
    }

    public static LookupService<Node, String> getLabelLookupService(QueryExecutionFactoryQuery conn, Property labelProperty, PrefixMapping prefixMapping, int partitionSize) {
        Fragment2 labelRelation = Fragment2Impl.create((Resource)labelProperty);
        return LookupServiceUtils.createLookupService(conn, labelRelation).partition(partitionSize).filterKeys(k -> k.isURI()).defaultForAbsentKeys(k -> null).cache().mapValues(LabelUtils::getLabelFromLookup);
    }

    public static String getLabelFromLookup(Node node, List<Node> results) {
        Node labelNode = results != null && !results.isEmpty() ? results.get(0) : node;
        String label = LabelUtils.deriveLabelFromNode(labelNode, null, null);
        return label;
    }

    public static String str(Node node, PrefixMapping prefixMapping) {
        PrefixMapAdapter pm = prefixMapping == null ? null : new PrefixMapAdapter(prefixMapping);
        String result = node == null ? "(null)" : NodeFmtLib.str((Node)node, (PrefixMap)pm);
        return result;
    }

    public static <T extends RDFNode, C extends Iterable<T>> C enrichWithLabels(C cs, Function<? super T, ? extends Node> nodeToLabel, LookupService<Node, String> labelService) {
        Map<T, String> labelMap = LabelUtils.getLabels(cs, nodeToLabel, labelService);
        for (Map.Entry<T, String> e : labelMap.entrySet()) {
            RDFNode rdfNode = (RDFNode)e.getKey();
            String label = e.getValue();
            if (!rdfNode.isResource()) continue;
            Resource k = rdfNode.asResource();
            ResourceUtils.setLiteralProperty((Resource)k, (Property)RDFS.label, (Object)label);
        }
        return cs;
    }

    public static String deriveLabelFromIri(String iriStr, PrefixMapping pm) {
        Map.Entry entry;
        Object result = null;
        if (pm != null && (entry = PrefixUtils.findLongestPrefix((PrefixMapping)pm, (String)iriStr)) != null) {
            String localName = iriStr.substring(((String)entry.getValue()).length());
            result = (String)entry.getKey() + ":" + localName;
        }
        if (result == null) {
            result = LabelUtils.deriveLabelFromIri(iriStr);
        }
        return result;
    }

    public static String deriveLabelFromIri(String iriStr) {
        int n = 6;
        int lastIdx = iriStr.length() - 1;
        int slashIdx = iriStr.lastIndexOf(47);
        int hashIdx = iriStr.lastIndexOf(35);
        String result = lastIdx - hashIdx <= n && slashIdx < hashIdx && slashIdx != -1 ? iriStr.substring(slashIdx + 1) : SplitIRI.localname((String)iriStr);
        return result;
    }

    public static String formatLiteralNode(Node node, PrefixMapping prefixMapping) {
        String result;
        if (node.isLiteral()) {
            boolean showDatatype;
            Object obj;
            try {
                obj = node.getLiteralValue();
            }
            catch (DatatypeFormatException e) {
                obj = null;
            }
            String baseStr = obj instanceof Number ? Objects.toString(obj) : node.getLiteralLexicalForm();
            String dtIri = node.getLiteralDatatypeURI();
            String dtPart = null;
            boolean bl = showDatatype = dtIri != null && !(obj instanceof String) && !(obj instanceof Number);
            if (showDatatype) {
                Map.Entry prefixToIri = prefixMapping == null ? null : PrefixUtils.findLongestPrefix((PrefixMapping)prefixMapping, (String)dtIri);
                String string = dtPart = prefixToIri != null ? (String)prefixToIri.getKey() + ":" + dtIri.substring(((String)prefixToIri.getValue()).length()) : "<" + dtIri + ">";
            }
            result = showDatatype ? "\"" + baseStr + "\"" + (String)(dtPart == null ? "" : "^^" + dtPart) : baseStr;
        } else {
            result = Objects.toString(node);
        }
        return result;
    }

    public static LookupService<Node, String> createLookupServiceForLabels(LookupService<Node, String> labelService, PrefixMapping iriPrefixes, PrefixMapping literalPrefixes) {
        return cs -> Flowable.fromIterable(LabelUtils.getLabels(cs, Function.identity(), labelService, iriPrefixes, literalPrefixes).entrySet());
    }

    public static String getOrDeriveLabel(RDFNode rdfNode) {
        return LabelUtils.getOrDeriveLabel(rdfNode, BestLiteralConfig.fromProperty((Property)RDFS.label));
    }

    public static String getOrDeriveLabel(RDFNode rdfNode, BestLiteralConfig bestLiteralConfig) {
        return LabelUtils.getOrDeriveLabel(rdfNode, bestLiteralConfig, null, null);
    }

    public static String getOrDeriveLabel(RDFNode rdfNode, BestLiteralConfig bestLiteralConfig, PrefixMapping iriPrefixes, PrefixMapping literalPrefixes) {
        Node tmp = rdfNode.isResource() ? LabelUtils.findBestLiteral(rdfNode, bestLiteralConfig) : null;
        Node labelNode = tmp != null ? tmp : rdfNode.asNode();
        String result = LabelUtils.deriveLabelFromNode(labelNode, iriPrefixes, literalPrefixes);
        return result;
    }

    public static String deriveLabelFromNode(Node node, PrefixMapping iriPrefixes, PrefixMapping literalPrefixes) {
        String result = node == null || NodeUtils.nullUriNode.equals((Object)node) ? "(null)" : (node.isURI() ? LabelUtils.deriveLabelFromIri(node.getURI(), iriPrefixes) : LabelUtils.formatLiteralNode(node, literalPrefixes));
        return result;
    }

    public static <T> Map<T, String> getLabels(Iterable<T> cs, Function<? super T, ? extends Node> nodeFunction, LookupService<Node, String> labelService) {
        return LabelUtils.getLabels(cs, nodeFunction, labelService, null, null);
    }

    public static <T> Map<T, String> getLabels(Iterable<T> cs, Function<? super T, ? extends Node> nodeFunction, LookupService<Node, String> labelService, PrefixMapping iriPrefixes, PrefixMapping literalPrefixes) {
        ImmutableListMultimap index = Multimaps.index(cs, item -> Optional.ofNullable((Node)nodeFunction.apply(item)).orElse(NodeUtils.nullUriNode));
        Set s = index.keySet().stream().filter(Node::isURI).collect(Collectors.toSet());
        Map map = labelService.fetchMap(s);
        Function<Node, String> determineLabel = k -> {
            String r = (String)map.get(k);
            if (r == null) {
                r = LabelUtils.deriveLabelFromNode(k, iriPrefixes, literalPrefixes);
            }
            return r;
        };
        Map<Object, String> result = index.entries().stream().map(e -> Maps.immutableEntry(e.getValue(), (Object)((String)determineLabel.apply((Node)e.getKey())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return result;
    }
}

