/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.update;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import org.aksw.jena_sparql_api.core.DatasetListener;
import org.aksw.jena_sparql_api.core.QuadContainmentChecker;
import org.aksw.jena_sparql_api.core.UpdateContext;
import org.aksw.jena_sparql_api.core.utils.UpdateExecutionUtils;
import org.aksw.jena_sparql_api.update.UpdateExecutionFactoryEventSource;
import org.aksw.jenax.connectionless.SparqlService;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;

public class UpdateProcessorEventSource
implements UpdateProcessor {
    protected UpdateExecutionFactoryEventSource factory;
    protected UpdateRequest updateRequest;
    protected Set<DatasetListener> listeners = new HashSet<DatasetListener>();

    public UpdateProcessorEventSource(UpdateExecutionFactoryEventSource factory, UpdateRequest updateRequest) {
        this.factory = factory;
        this.updateRequest = updateRequest;
    }

    public Context getContext() {
        return null;
    }

    public void abort() {
    }

    public void execute() {
        Iterable allListeners = Iterables.concat(this.listeners, (Iterable)this.factory.getDatasetListeners());
        UpdateContext context = this.factory.getContext();
        SparqlService sparqlService = context.getSparqlService();
        int batchSize = context.getBatchSize();
        QuadContainmentChecker containmentChecker = context.getContainmentChecker();
        UpdateExecutionUtils.executeUpdate(sparqlService, this.updateRequest, batchSize, containmentChecker, (Iterable<DatasetListener>)allListeners);
    }
}

