/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.retry.core;

import com.google.common.util.concurrent.ListenableFuture;
import com.nurkiewicz.asyncretry.AsyncRetryExecutor;
import com.nurkiewicz.asyncretry.backoff.Backoff;
import com.nurkiewicz.asyncretry.policy.AbortRetryException;
import com.nurkiewicz.asyncretry.policy.RetryPolicy;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.aksw.jenax.dataaccess.sparql.execution.query.QueryExecutionWrapperBase;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;

public class QueryExecutionRetry
extends QueryExecutionWrapperBase<QueryExecution> {
    protected Supplier<QueryExecution> supplier;
    protected int retryCount;
    protected long retryDelayInMs;
    protected RetryPolicy retryPolicy;
    protected Backoff backoff;
    protected boolean fixedDelay;
    protected Supplier<ScheduledExecutorService> scheduler;
    protected boolean aborted = false;
    private QueryExecutionRetryDecorateeProxy proxy;

    public QueryExecutionRetry(Supplier<QueryExecution> supplier, RetryPolicy retryPolicy, Backoff backoff, boolean fixedDelay, Supplier<ScheduledExecutorService> scheduler) {
        super((QueryExecution)new QueryExecutionRetryDecorateeProxy());
        this.supplier = supplier;
        this.retryPolicy = retryPolicy;
        this.backoff = backoff;
        this.fixedDelay = fixedDelay;
        this.scheduler = scheduler;
        ((QueryExecutionRetryDecorateeProxy)this.decoratee).setOwner(this);
    }

    public <T> T resolve(Callable<T> callable) {
        if (this.decoratee instanceof QueryExecutionRetryDecorateeProxy) {
            this.proxy = (QueryExecutionRetryDecorateeProxy)this.decoratee;
            this.decoratee = this.supplier.get();
            if (this.proxy.getInitialBinding() != null) {
                // empty if block
            }
            if (this.proxy.getTimeout1() > -1L || this.proxy.getTimeout2() > -1L) {
                // empty if block
            }
        }
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (this.aborted) {
                throw new AbortRetryException();
            }
            this.decoratee = this.proxy;
            this.proxy = null;
            throw new RuntimeException(e);
        }
    }

    public <T> T doTry(Callable<T> callable) {
        Callable<Object> wrapper = () -> this.resolve(callable);
        ScheduledExecutorService service = this.scheduler.get();
        AsyncRetryExecutor executor = new AsyncRetryExecutor(service, this.retryPolicy, this.backoff, this.fixedDelay);
        ListenableFuture future = executor.getWithRetry(wrapper);
        try {
            Object result;
            Object object = result = future.get();
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("Query Execution failed, even with retries.", e);
        }
        finally {
            service.shutdown();
        }
    }

    public void abort() {
        this.aborted = true;
        if (this.decoratee != null) {
            this.decoratee.abort();
        }
    }

    public boolean execAsk() {
        return this.doTry(() -> super.execAsk());
    }

    public ResultSet execSelect() {
        return this.doTry(() -> super.execSelect());
    }

    public Model execConstruct() {
        return this.doTry(() -> super.execConstruct());
    }

    public Model execConstruct(Model model) {
        return this.doTry(() -> super.execConstruct(model));
    }

    public Iterator<Triple> execConstructTriples() {
        return this.doTry(() -> super.execConstructTriples());
    }

    public Model execDescribe() {
        return this.doTry(() -> super.execDescribe());
    }

    public Model execDescribe(Model model) {
        return this.doTry(() -> super.execDescribe(model));
    }

    public Iterator<Triple> execDescribeTriples() {
        return this.doTry(() -> super.execDescribeTriples());
    }

    private static class QueryExecutionRetryDecorateeProxy
    implements QueryExecution {
        private QueryExecutionRetry owner;
        private QuerySolution initialBinding;
        private long timeout1 = -1L;
        private long timeout2 = -1L;

        private QueryExecutionRetryDecorateeProxy() {
        }

        public QuerySolution getInitialBinding() {
            return this.initialBinding;
        }

        public Dataset getDataset() {
            return this.owner.resolve(() -> ((QueryExecutionRetry)this.owner).getDataset());
        }

        public Context getContext() {
            return this.owner.resolve(() -> ((QueryExecutionRetry)this.owner).getContext());
        }

        public Query getQuery() {
            return this.owner.resolve(() -> ((QueryExecutionRetry)this.owner).getQuery());
        }

        public ResultSet execSelect() {
            return this.owner.execSelect();
        }

        public Model execConstruct() {
            return this.owner.execConstruct();
        }

        public Model execConstruct(Model model) {
            return this.owner.execConstruct(model);
        }

        public Iterator<Triple> execConstructTriples() {
            return this.owner.execConstructTriples();
        }

        public Iterator<Quad> execConstructQuads() {
            return this.owner.resolve(() -> ((QueryExecutionRetry)this.owner).execConstructQuads());
        }

        public Dataset execConstructDataset() {
            return this.owner.resolve(() -> ((QueryExecutionRetry)this.owner).execConstructDataset());
        }

        public Dataset execConstructDataset(Dataset dataset) {
            return this.owner.resolve(() -> this.owner.execConstructDataset(dataset));
        }

        public Model execDescribe() {
            return this.owner.execDescribe();
        }

        public Model execDescribe(Model model) {
            return this.owner.execDescribe(model);
        }

        public Iterator<Triple> execDescribeTriples() {
            return this.owner.execDescribeTriples();
        }

        public boolean execAsk() {
            return this.owner.execAsk();
        }

        public JsonArray execJson() {
            return this.owner.execJson();
        }

        public Iterator<JsonObject> execJsonItems() {
            return this.owner.execJsonItems();
        }

        public void abort() {
            if (this.owner.decoratee == this) {
                this.owner.decoratee = null;
            }
            this.owner.abort();
        }

        public void close() {
            if (this.owner.decoratee == this) {
                this.owner.decoratee = null;
            }
            this.owner.close();
        }

        public boolean isClosed() {
            return this.owner.isClosed();
        }

        public void setTimeout(long timeout, TimeUnit timeUnit) {
            long x = QueryExecutionRetryDecorateeProxy.asMillis(timeout, timeUnit);
            this.timeout1 = -1L;
            this.timeout2 = x;
        }

        public void setTimeout(long timeout) {
            this.setTimeout(timeout, TimeUnit.MILLISECONDS);
        }

        public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
            long x1 = QueryExecutionRetryDecorateeProxy.asMillis(timeout1, timeUnit1);
            long x2 = QueryExecutionRetryDecorateeProxy.asMillis(timeout2, timeUnit2);
            this.timeout1 = x1;
            this.timeout2 = timeout2 < 0L ? -1L : x2;
        }

        public void setTimeout(long timeout1, long timeout2) {
            this.setTimeout(timeout1, TimeUnit.MILLISECONDS, timeout2, TimeUnit.MILLISECONDS);
        }

        private static long asMillis(long duration, TimeUnit timeUnit) {
            return duration < 0L ? duration : timeUnit.toMillis(duration);
        }

        public long getTimeout1() {
            return this.timeout1;
        }

        public long getTimeout2() {
            return this.timeout2;
        }

        public void setOwner(QueryExecutionRetry owner) {
            this.owner = owner;
        }

        public String getQueryString() {
            return null;
        }
    }
}

