/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core.utils;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class SupplierExtendedIteratorTriples
implements Supplier<ExtendedIterator<Triple>> {
    protected String fileNameOrUrl;
    protected Lang langHint;

    public SupplierExtendedIteratorTriples(String fileNameOrUrl) {
        this(fileNameOrUrl, null);
    }

    public SupplierExtendedIteratorTriples(String fileNameOrUrl, Lang langHint) {
        this.fileNameOrUrl = fileNameOrUrl;
        this.langHint = langHint;
    }

    @Override
    public ExtendedIterator<Triple> get() {
        ExtendedIterator<Triple> result = SupplierExtendedIteratorTriples.createTripleIterator(this.fileNameOrUrl, this.langHint);
        return result;
    }

    public static ExtendedIterator<Triple> createTripleIterator(String fileNameOrUrl, Lang langHint) {
        TypedInputStream tis = RDFDataMgr.open((String)fileNameOrUrl);
        Lang lang = RDFDataMgr.determineLang((String)fileNameOrUrl, null, (Lang)langHint);
        String base = tis.getBaseURI();
        Iterator itTriple = RDFDataMgr.createIteratorTriples((InputStream)tis, (Lang)lang, (String)base);
        ExtendedIterator result = WrappedIterator.create((Iterator)Iter.onCloseIO((Iterator)itTriple, (Closeable)tis));
        return result;
    }
}

