/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.update;

import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.commons.util.string.StringUtils;
import org.aksw.jena_sparql_api.changeset.ChangeSet;
import org.aksw.jena_sparql_api.changeset.ChangeSetMetadata;
import org.aksw.jena_sparql_api.changeset.ChangeSetUtils;
import org.aksw.jena_sparql_api.core.DatasetListener;
import org.aksw.jena_sparql_api.core.SparqlServiceReference;
import org.aksw.jena_sparql_api.core.UpdateContext;
import org.aksw.jena_sparql_api.core.utils.UpdateExecutionUtils;
import org.aksw.jena_sparql_api.update.DiffQuadUtils;
import org.aksw.jenax.connectionless.SparqlService;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Quad;

public class DatasetListenerTrack
implements DatasetListener {
    private SparqlService trackerService;
    private ChangeSetMetadata changesetMetadata;
    private String prefix;

    public DatasetListenerTrack(SparqlService trackerService) {
        this(trackerService, new ChangeSetMetadata());
    }

    public DatasetListenerTrack(SparqlService trackerService, ChangeSetMetadata changesetMetadata) {
        this.trackerService = trackerService;
        this.changesetMetadata = changesetMetadata;
    }

    @Override
    public void onPreModify(Diff<Set<Quad>> quadDiff, UpdateContext updateContext) {
        SparqlService sparqlService = updateContext.getSparqlService();
        DatasetDescription datasetDescription = sparqlService.getDatasetDescription();
        SparqlServiceReference ssr = new SparqlServiceReference(sparqlService.getServiceUri(), datasetDescription);
        Map<Node, Diff<Set<Triple>>> tripleDiff = DiffQuadUtils.partitionQuads(quadDiff);
        String serviceUri = ssr.getServiceURL();
        this.prefix = "http://example.org/changeset-";
        Model finalModel = ModelFactory.createDefaultModel();
        for (Map.Entry<Node, Diff<Set<Triple>>> entry : tripleDiff.entrySet()) {
            Node g = entry.getKey();
            String graphUri = g.getURI();
            if (Quad.defaultGraphIRI.equals((Object)g) || Quad.defaultGraphNodeGenerated.equals((Object)g)) {
                throw new RuntimeException("Should not happen - default graph uris are assumed to have been replaced");
            }
            String p = this.prefix + StringUtils.urlEncode((String)serviceUri) + "-" + StringUtils.urlEncode((String)graphUri) + "-";
            Diff<Set<Triple>> diff = entry.getValue();
            QueryExecutionFactory qef = this.trackerService.getQueryExecutionFactory();
            Map<Node, ChangeSet> changesets = ChangeSetUtils.createChangeSets((QueryExecutionFactoryQuery)qef, serviceUri, graphUri, this.changesetMetadata, diff, p);
            for (ChangeSet changeset : changesets.values()) {
                Model model = ModelFactory.createDefaultModel();
                ChangeSetUtils.write(model, changeset);
                ChangeSetUtils.enrichWithSource(model, g, ssr);
                finalModel.add(model);
            }
        }
        UpdateExecutionFactory uef = this.trackerService.getUpdateExecutionFactory();
        UpdateExecutionUtils.executeInsert(uef, finalModel);
    }
}

