/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.pagination.core;

import java.util.Iterator;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryBackQuery;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.pagination.core.PaginationUtils;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionIterated;
import org.aksw.jenax.arq.util.exec.query.PaginationQueryIterator;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;

public class QueryExecutionFactoryPaginated
extends QueryExecutionFactoryBackQuery {
    public static final long DEFAULT_PAGE_SIZE = 1000L;
    private QueryExecutionFactory decoratee;
    private long pageSize;

    public QueryExecutionFactoryPaginated(QueryExecutionFactory decoratee) {
        this(decoratee, PaginationUtils.adjustPageSize(decoratee, 1000L));
    }

    public QueryExecutionFactoryPaginated(QueryExecutionFactory decoratee, long pageSize) {
        this.pageSize = pageSize;
        this.decoratee = decoratee;
    }

    public QueryExecution createQueryExecution(Query query) {
        return QueryExecutionFactoryPaginated.createQueryExecution(this.decoratee, query, this.pageSize);
    }

    public static QueryExecution createQueryExecution(QueryExecutionFactory qef, Query query, long pageSize) {
        Query q = query.cloneQuery();
        PaginationQueryIterator queryIterator = new PaginationQueryIterator(q, pageSize);
        return new QueryExecutionIterated(query, qef, (Iterator<Query>)queryIterator);
    }

    public String getId() {
        return this.decoratee.getId();
    }

    public String getState() {
        return this.decoratee.getState();
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public static void main(String[] args) {
        QueryExecutionFactoryHttp factory = new QueryExecutionFactoryHttp("http://linkedgeodata.org/sparql", "http://linkedgeodata.org");
        QueryExecutionFactoryPaginated fp = new QueryExecutionFactoryPaginated(factory, 10000L);
        System.out.println(fp.getPageSize());
    }
}

