/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.dereference;

import java.io.IOException;
import java.net.URISyntaxException;
import org.aksw.jena_sparql_api.core.QueryExecutionBaseSelect;
import org.aksw.jena_sparql_api.dereference.Dereferencer;
import org.aksw.jenax.arq.util.exec.query.QueryExecutionAdapter;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class QueryExecutionDereference
extends QueryExecutionAdapter {
    private Query query;
    private Dereferencer dereferencer;

    public QueryExecutionDereference(Query query, Dereferencer dereferencer) {
        this.query = query;
        this.dereferencer = dereferencer;
    }

    public Model execDescribe() {
        try {
            return this._execDescribe(ModelFactory.createDefaultModel());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Model execDescribe(Model model) {
        try {
            Model result = this._execDescribe(model);
            if (model != result) {
                result.add(model);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Model _execDescribe(Model model) throws IOException, URISyntaxException {
        Node node = QueryExecutionBaseSelect.extractDescribeNode(this.query);
        return this.dereferencer.dereference(node.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        QueryExecutionDereference queryExecutionDereference = this;
        synchronized (queryExecutionDereference) {
            if (this.dereferencer != null) {
                try {
                    this.dereferencer.close();
                    this.dereferencer = null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

