/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core.utils;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.aksw.jena_sparql_api.core.utils.F_TripleToBinding;
import org.aksw.jenax.arq.util.exec.query.QueryExecutionAdapter;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetCloseable;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;

public class ResultSetUtils {
    public static ResultSetCloseable fromXml(InputStream xmlInputStream) {
        ResultSet rs = ResultSetFactory.fromXML((InputStream)xmlInputStream);
        ResultSetCloseable result = ResultSetUtils.wrap(rs, xmlInputStream);
        return result;
    }

    public static ResultSetCloseable wrap(ResultSet rs, final AutoCloseable closeable) {
        QueryExecutionAdapter dummy = new QueryExecutionAdapter(){

            public void close() {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ResultSetCloseable result = new ResultSetCloseable(rs, (QueryExecution)dummy);
        return result;
    }

    public static ResultSetCloseable tripleIteratorToResultSet(Iterator<Triple> tripleIt, QueryExecution closeable) {
        Iterator bindingIt = Iterators.transform(tripleIt, (Function)F_TripleToBinding.fn);
        QueryIterator queryIter = QueryIterPlainWrapper.create((Iterator)bindingIt);
        List<String> varNames = Arrays.asList("s", "p", "o");
        ResultSet baseRs = ResultSetFactory.create((QueryIterator)queryIter, varNames);
        ResultSetCloseable result = new ResultSetCloseable(baseRs, closeable);
        return result;
    }
}

