/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.compare;

import com.google.common.base.Stopwatch;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.commons.collections.diff.ListDiff;
import org.aksw.commons.util.io.out.OutputStreamUtils;
import org.aksw.commons.util.string.StringUtils;
import org.aksw.jenax.arq.util.binding.ResultSetCompareUtils;
import org.aksw.jenax.arq.util.binding.TableUtils;
import org.aksw.jenax.arq.util.triple.ModelDiff;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionCompare
implements QueryExecution {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionCompare.class);
    private boolean isOrdered;
    private QueryExecution a;
    private QueryExecution b;
    private Query query = null;
    private String queryString;
    private Diff<Table> resultSetDiff = null;
    private ModelDiff modelDiff = null;
    private Diff<Dataset> datasetDiff = null;
    private Diff<Boolean> askDiff = null;

    public static ModelDiff compareModel(Model a, Model b) {
        ModelDiff result = new ModelDiff();
        ((Model)result.getAdded()).add(b);
        ((Model)result.getAdded()).remove(a);
        ((Model)result.getRemoved()).add(a);
        ((Model)result.getRemoved()).remove(b);
        return result;
    }

    public static Diff<Dataset> compareDataset(Dataset a, Dataset b) {
        Diff result = new Diff((Object)DatasetFactory.create(), (Object)DatasetFactory.create(), (Object)DatasetFactory.create());
        ((Dataset)result.getAdded()).asDatasetGraph().addAll(b.asDatasetGraph());
        a.asDatasetGraph().find().forEachRemaining(arg_0 -> ((DatasetGraph)((Dataset)result.getAdded()).asDatasetGraph()).delete(arg_0));
        ((Dataset)result.getRemoved()).asDatasetGraph().addAll(a.asDatasetGraph());
        b.asDatasetGraph().find().forEachRemaining(arg_0 -> ((DatasetGraph)((Dataset)result.getRemoved()).asDatasetGraph()).delete(arg_0));
        return result;
    }

    public boolean isDifference() {
        if (this.resultSetDiff != null) {
            return !((Table)this.resultSetDiff.getAdded()).isEmpty() || !((Table)this.resultSetDiff.getRemoved()).isEmpty();
        }
        if (this.modelDiff != null) {
            return !((Model)this.modelDiff.getAdded()).isEmpty() || !((Model)this.modelDiff.getRemoved()).isEmpty();
        }
        if (this.askDiff != null) {
            return this.askDiff.getAdded() != this.askDiff.getRemoved();
        }
        throw new RuntimeException("Cannot retrieve difference because query was not executed.");
    }

    public QueryExecutionCompare(Query query, QueryExecution a, QueryExecution b, boolean isOrdered) {
        this(query, String.valueOf(query), a, b, isOrdered);
    }

    public QueryExecutionCompare(Query query, String queryString, QueryExecution a, QueryExecution b, boolean isOrdered) {
        this.query = query;
        this.queryString = queryString;
        this.a = a;
        this.b = b;
        this.isOrdered = isOrdered;
    }

    public Dataset getDataset() {
        return null;
    }

    public Context getContext() {
        return null;
    }

    public Query getQuery() {
        return this.query;
    }

    public ResultSet execSelect() {
        ResultSetRewindable y;
        ResultSetRewindable x;
        long timeA = -1L;
        long timeB = -1L;
        try {
            Stopwatch asw = Stopwatch.createStarted();
            ResultSet r = this.a.execSelect();
            x = ResultSetFactory.makeRewindable((ResultSet)r);
            x.reset();
            timeA = asw.stop().elapsed(TimeUnit.MILLISECONDS);
            Stopwatch bsw = Stopwatch.createStarted();
            ResultSet s = this.b.execSelect();
            y = ResultSetFactory.makeRewindable((ResultSet)s);
            y.reset();
            timeB = bsw.stop().elapsed(TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException e) {
            this.resultSetDiff = Diff.create((Object)TableFactory.createEmpty(), (Object)TableFactory.createEmpty());
            throw new RuntimeException(e);
        }
        ListDiff tmp = this.isOrdered ? ResultSetCompareUtils.compareOrdered((ResultSet)x, (ResultSet)y) : ResultSetCompareUtils.compareUnordered((ResultSet)x, (ResultSet)y);
        this.resultSetDiff = Diff.create((Object)TableUtils.createTable((List)Var.varList((Collection)x.getResultVars()), (Iterable)((Iterable)tmp.getAdded())), (Object)TableUtils.createTable((List)Var.varList((Collection)y.getResultVars()), (Iterable)((Iterable)tmp.getRemoved())));
        x.reset();
        this.logResultSet();
        String relation = timeA == timeB ? "=" : (timeA > timeB ? ">" : "<");
        logger.debug("Execution time relation: [" + timeA + " " + relation + " " + timeB + "]");
        return x;
    }

    public void log(long added, long removed) {
        boolean isEqual;
        String msg = added + "\t" + removed + "\t" + StringUtils.urlEncode((String)String.valueOf(this.query));
        boolean bl = isEqual = added == 0L && removed == 0L;
        if (isEqual) {
            logger.info("[ OK ] " + msg);
        } else {
            logger.warn("[FAIL] " + msg);
        }
    }

    public void log(Table ra, Table rb) {
        boolean isEqual;
        this.log(ra.size(), rb.size());
        boolean bl = isEqual = ra.isEmpty() && rb.isEmpty();
        if (!isEqual) {
            ResultSet rsa = TableUtils.toResultSet((Table)ra);
            ResultSet rsb = TableUtils.toResultSet((Table)rb);
            logger.debug("Differences detected for query: \n" + this.queryString);
            logger.debug("Excessive:\n" + ResultSetFormatter.asText((ResultSet)rsa));
            logger.debug("Missing:\n" + ResultSetFormatter.asText((ResultSet)rsb));
        }
    }

    public void logResultSet() {
        this.log((Table)this.resultSetDiff.getAdded(), (Table)this.resultSetDiff.getRemoved());
    }

    public void logModel() {
        this.log(((Model)this.modelDiff.getAdded()).size(), ((Model)this.modelDiff.getRemoved()).size());
        logger.debug("Query: " + String.valueOf(this.query));
        logger.debug("Excessive:\n" + QueryExecutionCompare.toString((Model)this.modelDiff.getAdded(), RDFFormat.TURTLE_PRETTY));
        logger.debug("Missing:\n" + QueryExecutionCompare.toString((Model)this.modelDiff.getRemoved(), RDFFormat.TURTLE_PRETTY));
    }

    public void logDataset() {
        this.log(((Dataset)this.datasetDiff.getAdded()).asDatasetGraph().size(), ((Dataset)this.datasetDiff.getRemoved()).asDatasetGraph().size());
        logger.debug("Query: " + String.valueOf(this.query));
        logger.debug("Excessive:\n" + QueryExecutionCompare.toString((Dataset)this.datasetDiff.getAdded(), RDFFormat.TRIG_PRETTY));
        logger.debug("Missing:\n" + QueryExecutionCompare.toString((Dataset)this.datasetDiff.getRemoved(), RDFFormat.TRIG_PRETTY));
    }

    public static String toString(Model model, RDFFormat format) {
        String result = OutputStreamUtils.toStringUtf8(out -> RDFDataMgr.write((OutputStream)out, (Model)model, (RDFFormat)format));
        return result;
    }

    public static String toString(Dataset dataset, RDFFormat format) {
        String result = OutputStreamUtils.toStringUtf8(out -> RDFDataMgr.write((OutputStream)out, (Dataset)dataset, (RDFFormat)format));
        return result;
    }

    public void logAsk() {
        boolean added = (Boolean)this.askDiff.getAdded();
        boolean removed = (Boolean)this.askDiff.getRemoved();
        String msg = added + "\t" + removed + "\t" + StringUtils.urlEncode((String)String.valueOf(this.query));
        if (added == removed) {
            logger.trace("[ OK ] " + msg);
        } else {
            logger.warn("[FAIL] " + msg);
        }
    }

    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    public Model execConstruct(Model model) {
        Model y;
        Model x;
        try {
            x = this.a.execConstruct();
            y = this.b.execConstruct();
        }
        catch (RuntimeException e) {
            this.modelDiff = new ModelDiff();
            throw e;
        }
        this.modelDiff = QueryExecutionCompare.compareModel(x, y);
        this.logModel();
        return x;
    }

    public Model execDescribe() {
        return this.execDescribe(ModelFactory.createDefaultModel());
    }

    public Model execDescribe(Model model) {
        Model y;
        Model x;
        try {
            x = this.a.execDescribe();
            y = this.b.execDescribe();
        }
        catch (RuntimeException e) {
            this.modelDiff = new ModelDiff();
            throw e;
        }
        this.modelDiff = QueryExecutionCompare.compareModel(x, y);
        this.logModel();
        return x;
    }

    public boolean execAsk() {
        boolean y;
        boolean x;
        try {
            x = this.a.execAsk();
            y = this.b.execAsk();
        }
        catch (RuntimeException e) {
            this.askDiff = new Diff((Object)false, (Object)false, null);
            throw e;
        }
        this.askDiff = new Diff((Object)x, (Object)y, null);
        this.logAsk();
        return x;
    }

    public void abort() {
        try {
            this.a.abort();
        }
        finally {
            this.b.abort();
        }
    }

    public void close() {
        try {
            this.a.close();
        }
        finally {
            this.b.close();
        }
    }

    public Iterator<Triple> execConstructTriples() {
        Model tmp = this.execConstruct();
        Iterator<Triple> result = tmp.getGraph().find(Node.ANY, Node.ANY, Node.ANY).toSet().iterator();
        return result;
    }

    public Iterator<Triple> execDescribeTriples() {
        Model tmp = this.execDescribe();
        Iterator<Triple> result = tmp.getGraph().find(Node.ANY, Node.ANY, Node.ANY).toSet().iterator();
        return result;
    }

    public long getTimeout1() {
        return this.a.getTimeout1();
    }

    public long getTimeout2() {
        return this.a.getTimeout2();
    }

    public boolean isClosed() {
        return this.a.isClosed() && this.b.isClosed();
    }

    public Iterator<Quad> execConstructQuads() {
        Dataset tmp = this.execConstructDataset();
        Iterator result = tmp.asDatasetGraph().find();
        return result;
    }

    public Dataset execConstructDataset() {
        return this.execConstructDataset(DatasetFactory.create());
    }

    public Dataset execConstructDataset(Dataset dataset) {
        Dataset y;
        Dataset x;
        try {
            x = this.a.execConstructDataset();
            y = this.b.execConstructDataset();
        }
        catch (RuntimeException e) {
            this.datasetDiff = new Diff((Object)DatasetFactory.create(), (Object)DatasetFactory.create(), (Object)DatasetFactory.create());
            throw e;
        }
        this.datasetDiff = QueryExecutionCompare.compareDataset(x, y);
        this.logDataset();
        return x;
    }

    public JsonArray execJson() {
        throw new RuntimeException("Not implemented yet");
    }

    public Iterator<JsonObject> execJsonItems() {
        throw new RuntimeException("Not implemented yet");
    }

    public String getQueryString() {
        return null;
    }
}

