/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.staging;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.GregorianCalendar;
import org.aksw.commons.util.StreamUtils;
import org.aksw.commons.util.closeable.AutoCloseables;
import org.aksw.commons.util.string.StringUtils;
import org.aksw.jena_sparql_api.cache.extra.CacheEntryImpl;
import org.aksw.jena_sparql_api.cache.extra.SqlUtils;
import org.aksw.jena_sparql_api.cache.staging.CacheBackendDao;
import org.aksw.jena_sparql_api.cache.staging.CacheCoreIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheBackendDaoPostgres
implements CacheBackendDao {
    private static final Logger logger = LoggerFactory.getLogger(CacheBackendDaoPostgres.class);
    private boolean validateHash = true;
    private long timeToLive;
    private String QUERY_LOOKUP = "SELECT * FROM \"query_cache\" WHERE \"id\" = ?";
    private String QUERY_INSERT = "INSERT INTO \"query_cache\"(\"id\", \"query_string\", \"data\", \"time_of_insertion\", \"hit_count\") VALUES (?, ?, ?, ?, ?)";
    private String QUERY_UPDATE = "UPDATE \"query_cache\" SET \"data\"=?, \"time_of_insertion\" = ? WHERE \"id\" = ?";

    public CacheBackendDaoPostgres() {
        this(86400000L);
    }

    public CacheBackendDaoPostgres(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    @Override
    public CacheEntryImpl lookup(final Connection conn, String service, String queryString, final boolean closeConn) throws SQLException {
        String md5 = StringUtils.md5Hash((String)this.createHashRoot(service, queryString));
        Object[] args = new Object[]{md5};
        String sql = this.QUERY_LOOKUP;
        logger.trace("Executing statement '" + sql + "' with args " + String.valueOf(Arrays.asList(args)));
        final PreparedStatement stmt = conn.prepareStatement(sql);
        SqlUtils.executeSetArgs(stmt, args);
        final ResultSet rs = stmt.executeQuery();
        Closeable closeAction = new Closeable(){
            boolean isClosed = false;

            @Override
            public void close() {
                if (!this.isClosed) {
                    SqlUtils.close(rs);
                    SqlUtils.close(stmt);
                    if (closeConn) {
                        try {
                            conn.commit();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        SqlUtils.close(conn);
                    }
                }
                this.isClosed = true;
            }
        };
        CacheEntryImpl result = null;
        if (rs.next()) {
            String cachedQueryString;
            result = CacheCoreIterator.createCacheEntry(rs, closeAction, this.timeToLive);
            if (this.validateHash && !(cachedQueryString = result.getQueryString()).equals(queryString)) {
                logger.error("HASH-CLASH:\nService: " + service + "\nNew QueryString: " + queryString + "\nOld QueryString: " + cachedQueryString);
                throw new RuntimeException("Hash-Clash - Man you're lucky");
            }
        } else {
            AutoCloseables.close((AutoCloseable)closeAction);
        }
        return result;
    }

    @Override
    public void write(Connection conn, String service, String queryString, InputStream in) throws SQLException, IOException {
        String hack;
        boolean doesEntryExist;
        String md5 = StringUtils.md5Hash((String)this.createHashRoot(service, queryString));
        CacheEntryImpl entry = this.lookup(conn, service, queryString, false);
        boolean bl = doesEntryExist = entry != null;
        if (doesEntryExist) {
            entry.getInputStream().close();
        }
        Timestamp timestamp = new Timestamp(new GregorianCalendar().getTimeInMillis());
        try {
            hack = StreamUtils.toString((InputStream)in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (doesEntryExist) {
            SqlUtils.execute(conn, this.QUERY_UPDATE, Void.class, hack, timestamp, md5);
        } else {
            SqlUtils.execute(conn, this.QUERY_INSERT, Void.class, md5, queryString, hack, timestamp, 1);
        }
    }

    public String createHashRoot(String service, String queryString) {
        return service + " " + queryString;
    }
}

