/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.file;

import com.google.common.io.MoreFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.aksw.commons.util.StreamUtils;
import org.aksw.commons.util.string.StringUtils;
import org.aksw.jena_sparql_api.cache.extra.CacheBackend;
import org.aksw.jena_sparql_api.cache.extra.CacheEntry;
import org.aksw.jena_sparql_api.cache.file.CacheEntryFile;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class CacheBackendFile
implements CacheBackend {
    protected Path parentFile;
    protected long lifespan;
    protected boolean useCompression;
    protected boolean isReadonly;
    protected boolean writeQuery;

    public CacheBackendFile(File parentFile, long lifespan) {
        this(parentFile.toPath(), lifespan, true, false, false);
    }

    public CacheBackendFile(Path parentFile, long lifespan, boolean useCompression, boolean isReadonly, boolean writeQuery) {
        this.parentFile = parentFile;
        this.lifespan = lifespan;
        this.useCompression = useCompression;
        this.isReadonly = isReadonly;
        this.writeQuery = writeQuery;
        if (!isReadonly && !Files.exists(parentFile, new LinkOption[0])) {
            try {
                Files.createDirectories(parentFile, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        boolean canWrite = Files.isWritable(parentFile);
        if (!isReadonly && !canWrite) {
            throw new RuntimeException("Cache cannot write to: " + String.valueOf(parentFile.toAbsolutePath()));
        }
    }

    @Override
    public CacheEntry lookup(String service, String queryString) {
        String baseFileName = StringUtils.urlEncode((String)service) + "-" + StringUtils.md5Hash((String)queryString);
        String fileName = baseFileName + ".dat" + (this.useCompression ? ".bz2" : "");
        Path file = this.parentFile.resolve(fileName);
        CacheEntryFile result = Files.exists(file, new LinkOption[0]) ? new CacheEntryFile(file, this.lifespan, this.useCompression) : null;
        return result;
    }

    @Override
    public void write(String service, String queryString, InputStream in) {
        Path file;
        Path queryFile;
        if (this.isReadonly) {
            throw new RuntimeException("Cannot write to readonly cache");
        }
        String baseFileName = StringUtils.urlEncode((String)service) + "-" + StringUtils.md5Hash((String)queryString);
        String dataFileName = baseFileName + ".dat" + (this.useCompression ? ".bz2" : "");
        if (this.writeQuery && !Files.exists(queryFile = this.parentFile.resolve(baseFileName + ".sparql"), new LinkOption[0])) {
            try {
                MoreFiles.asCharSink((Path)queryFile, (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]).write((CharSequence)queryString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (Files.exists(file = this.parentFile.resolve(dataFileName), new LinkOption[0])) {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String tmpFileName = dataFileName + ".tmp";
        Path tmpFile = this.parentFile.resolve(tmpFileName);
        try {
            if (!Files.exists(tmpFile, new LinkOption[0])) {
                Files.createFile(tmpFile, new FileAttribute[0]);
            }
            OutputStream fos = Files.newOutputStream(tmpFile, new OpenOption[0]);
            OutputStream out = this.useCompression ? new BZip2CompressorOutputStream(fos) : fos;
            StreamUtils.copyThenClose((InputStream)in, (OutputStream)out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            Files.move(tmpFile, file, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadonly;
    }
}

