/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.update;

import com.google.common.base.Supplier;
import java.net.http.HttpClient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.aksw.jena_sparql_api.core.FluentBase;
import org.aksw.jena_sparql_api.core.FluentQueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlServiceImpl;
import org.aksw.jena_sparql_api.core.SparqlServiceReference;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactoryHttp;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.update.FluentSparqlServiceFn;
import org.aksw.jena_sparql_api.update.FluentUpdateExecutionFactory;
import org.aksw.jenax.connectionless.SparqlService;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryOverSparqlQueryConnection;
import org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactorySparqlUpdateConnection;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.rdfconnection.SparqlUpdateConnection;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.util.Context;

public class FluentSparqlService<P>
extends FluentBase<SparqlService, P> {
    public FluentSparqlService(SparqlService sparqlService) {
        this.fn = sparqlService;
    }

    public FluentSparqlServiceFn<FluentSparqlService<P>> config() {
        final FluentSparqlService self = this;
        final FluentSparqlServiceFn<FluentSparqlService<P>> result = new FluentSparqlServiceFn<FluentSparqlService<P>>();
        result.setParentSupplier(new Supplier<FluentSparqlService<P>>(){

            public FluentSparqlService<P> get() {
                Object transform = result.value();
                FluentSparqlService.this.fn = transform.apply((SparqlService)FluentSparqlService.this.fn);
                return self;
            }
        });
        return result;
    }

    public static FluentSparqlService<?> forModel() {
        Model model = ModelFactory.createDefaultModel();
        FluentSparqlService<?> result = FluentSparqlService.from(model);
        return result;
    }

    public static FluentSparqlService<?> from(Model model) {
        FluentSparqlService<?> result = FluentSparqlService.from(model, null);
        return result;
    }

    public static FluentSparqlService<?> from(Model model, Context context) {
        QueryExecutionFactory qef = (QueryExecutionFactory)FluentQueryExecutionFactory.model(model, context).create();
        UpdateExecutionFactory uef = FluentUpdateExecutionFactory.from(model, context).create();
        FluentSparqlService<?> result = FluentSparqlService.from(qef, uef);
        return result;
    }

    public static FluentSparqlService<?> forDataset() {
        Dataset dataset = DatasetFactory.createGeneral();
        FluentSparqlService<?> result = FluentSparqlService.from(dataset);
        return result;
    }

    public static FluentSparqlService<?> from(Dataset dataset) {
        QueryExecutionFactory qef = (QueryExecutionFactory)FluentQueryExecutionFactory.from(dataset).create();
        UpdateExecutionFactory uef = FluentUpdateExecutionFactory.from(dataset).create();
        FluentSparqlService<?> result = FluentSparqlService.from(qef, uef);
        return result;
    }

    public static FluentSparqlService<?> forDatasetGraph() {
        DatasetGraph datasetGraph = DatasetGraphFactory.createGeneral();
        FluentSparqlService<?> result = FluentSparqlService.from(datasetGraph);
        return result;
    }

    public static FluentSparqlService<?> from(DatasetGraph datasetGraph) {
        FluentSparqlService<?> result = FluentSparqlService.from(datasetGraph, null);
        return result;
    }

    public static FluentSparqlService<?> from(DatasetGraph datasetGraph, Context context) {
        QueryExecutionFactory qef = (QueryExecutionFactory)FluentQueryExecutionFactory.from(datasetGraph, context).create();
        UpdateExecutionFactory uef = FluentUpdateExecutionFactory.from(datasetGraph, context).create();
        FluentSparqlService<?> result = FluentSparqlService.from(qef, uef);
        return result;
    }

    public static FluentSparqlService<?> http(String service, String ... defaultGraphs) {
        return FluentSparqlService.http(service, Arrays.asList(defaultGraphs));
    }

    public static FluentSparqlService<?> http(String service, String defaultGraph, HttpClient httpClient) {
        return FluentSparqlService.http(service, new DatasetDescription(Collections.singletonList(defaultGraph), Collections.emptyList()), httpClient);
    }

    public static FluentSparqlService<?> http(SparqlServiceReference sparqlService) {
        return FluentSparqlService.http(sparqlService.getServiceURL(), sparqlService.getDatasetDescription());
    }

    public static FluentSparqlService<?> http(String service, List<String> defaultGraphs) {
        DatasetDescription datasetDescription = new DatasetDescription(defaultGraphs, Collections.emptyList());
        return FluentSparqlService.http(service, datasetDescription, null);
    }

    public static FluentSparqlService<?> http(String service, DatasetDescription datasetDescription) {
        return FluentSparqlService.http(service, datasetDescription, null);
    }

    public static FluentSparqlService<?> http(String service, DatasetDescription datasetDescription, HttpClient httpClient) {
        QueryExecutionFactoryHttp qef = new QueryExecutionFactoryHttp(service, datasetDescription, httpClient);
        UpdateExecutionFactoryHttp uef = new UpdateExecutionFactoryHttp(service, datasetDescription, httpClient);
        return FluentSparqlService.from(service, datasetDescription, qef, uef);
    }

    public static FluentSparqlService<?> from(QueryExecutionFactory qef, UpdateExecutionFactory uef) {
        FluentSparqlService<?> result = FluentSparqlService.from(null, null, qef, uef);
        return result;
    }

    public static FluentSparqlService<?> from(String serviceUri, DatasetDescription datasetDescription, QueryExecutionFactory qef, UpdateExecutionFactory uef) {
        SparqlServiceImpl sparqlService = new SparqlServiceImpl(serviceUri, datasetDescription, qef, uef);
        FluentSparqlService<?> result = FluentSparqlService.from(sparqlService);
        return result;
    }

    public static FluentSparqlService<?> from(SparqlService sparqlService) {
        FluentSparqlService result = new FluentSparqlService(sparqlService);
        return result;
    }

    public static FluentSparqlService<?> from(RDFConnection conn) {
        SparqlServiceImpl sparqlService = new SparqlServiceImpl(null, null, (QueryExecutionFactory)new QueryExecutionFactoryOverSparqlQueryConnection((SparqlQueryConnection)conn), (UpdateExecutionFactory)new UpdateExecutionFactorySparqlUpdateConnection((SparqlUpdateConnection)conn));
        FluentSparqlService<?> result = FluentSparqlService.from(sparqlService);
        return result;
    }
}

