/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.pagination.core;

import java.util.Iterator;
import java.util.List;
import org.aksw.commons.util.closeable.AutoCloseables;
import org.aksw.jena_sparql_api.pagination.core.MyQueryIteratorWrapper;
import org.aksw.jena_sparql_api.pagination.core.PrefetchIteratorForJena;
import org.aksw.jena_sparql_api.pagination.core.ResultSetPaginated;
import org.aksw.jenax.arq.util.exec.query.QueryExecutionAdapter;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIteratorCloseable;
import org.apache.jena.sparql.util.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionIterated
extends QueryExecutionAdapter {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionIterated.class);
    protected QueryExecutionFactory factory;
    protected Iterator<Query> queryIterator;
    protected boolean stopOnEmptyResult;
    protected boolean stopIfLimitNotReached;
    protected java.io.Closeable currentCloseAction = null;
    protected Query originalQuery;

    public QueryExecutionIterated(Query originalQuery, QueryExecutionFactory factory, Iterator<Query> queryIterator) {
        this(originalQuery, factory, queryIterator, true, true);
    }

    public QueryExecutionIterated(Query originalQuery, QueryExecutionFactory factory, Iterator<Query> queryIterator, boolean stopOnEmptyResult, boolean stopIfLimitNotReached) {
        this.originalQuery = originalQuery;
        this.queryIterator = queryIterator;
        this.factory = factory;
        this.stopOnEmptyResult = stopOnEmptyResult;
        this.stopIfLimitNotReached = stopIfLimitNotReached;
    }

    public Query getQuery() {
        return this.originalQuery;
    }

    public boolean execAsk() {
        Query query = this.queryIterator.next();
        query.setLimit(Long.MIN_VALUE);
        QueryExecution qe = this.factory.createQueryExecution(query);
        boolean result = qe.execAsk();
        return result;
    }

    public ResultSet execSelect() {
        ResultSetPaginated it = new ResultSetPaginated(this.factory, this.queryIterator, this.stopOnEmptyResult, this.stopIfLimitNotReached);
        it.hasNext();
        ResultSet tmp = it.getCurrentResultSet();
        if (tmp == null) {
            throw new RuntimeException("Underlying result set not avaliable - probably a query failed.");
        }
        List<String> resultVars = it.getCurrentResultVars();
        MyQueryIteratorWrapper myQueryIterator = new MyQueryIteratorWrapper((Iterator<Binding>)((Object)it));
        QueryIteratorCloseable itClosable = new QueryIteratorCloseable((QueryIterator)myQueryIterator, (Closeable)it);
        ResultSet rs = ResultSetFactory.create((QueryIterator)itClosable, resultVars);
        return rs;
    }

    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    public Iterator<Triple> execConstructTriples() {
        return new PrefetchIteratorForJena<Triple>(){
            QueryExecution current = null;
            QueryExecution counter = null;

            protected Iterator<Triple> prefetch() throws Exception {
                Iterator r;
                Query query;
                if (this.current != null) {
                    this.current.close();
                }
                Query query2 = query = QueryExecutionIterated.this.queryIterator.hasNext() ? QueryExecutionIterated.this.queryIterator.next() : null;
                if (query != null && QueryExecutionIterated.this.stopOnEmptyResult) {
                    boolean isEmpty;
                    Query clone = query.cloneQuery();
                    clone.setQuerySelectType();
                    clone.setQueryResultStar(true);
                    clone.setLimit(1L);
                    try (QueryExecution qe = this.counter = QueryExecutionIterated.this.factory.createQueryExecution(clone);){
                        ResultSet rs = qe.execSelect();
                        isEmpty = !rs.hasNext();
                    }
                    this.counter = null;
                    if (isEmpty) {
                        query = null;
                    }
                }
                if (query != null) {
                    this.current = QueryExecutionIterated.this.factory.createQueryExecution(query);
                    r = this.current.execConstructTriples();
                    QueryExecutionIterated.this.currentCloseAction = () -> this.close();
                } else {
                    r = null;
                }
                return r;
            }

            public void close() {
                try {
                    if (this.counter != null) {
                        this.counter.close();
                    }
                }
                finally {
                    if (this.current != null) {
                        this.current.close();
                    }
                }
            }
        };
    }

    public Model execConstruct(Model result) {
        Iterator<Triple> it = this.execConstructTriples();
        StmtIterator iter = ModelUtils.triplesToStatements(it, (Model)result);
        result.add(iter);
        return result;
    }

    public void close() {
        AutoCloseables.close((AutoCloseable)this.currentCloseAction);
    }
}

