/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core.utils;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.jena_sparql_api.core.DatasetListener;
import org.aksw.jena_sparql_api.core.QuadContainmentChecker;
import org.aksw.jena_sparql_api.core.UpdateContext;
import org.aksw.jena_sparql_api.core.utils.DatasetListenerUtils;
import org.aksw.jena_sparql_api.core.utils.FN_QuadDiffUnique;
import org.aksw.jena_sparql_api.core.utils.UpdateDiffUtils;
import org.aksw.jenax.arq.util.dataset.DatasetDescriptionUtils;
import org.aksw.jenax.arq.util.exception.HttpExceptionUtils;
import org.aksw.jenax.arq.util.node.NodeTransformRenameMap;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.quad.DatasetGraphDiffUtils;
import org.aksw.jenax.arq.util.quad.FN_QuadFromTriple;
import org.aksw.jenax.arq.util.quad.QuadUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.update.UpdateRequestUtils;
import org.aksw.jenax.arq.util.update.UpdateUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.connectionless.SparqlService;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.modify.request.UpdateDeleteInsert;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateExecutionUtils {
    private static final Logger logger = LoggerFactory.getLogger(UpdateExecutionUtils.class);

    public static void copyByConstruct(SparqlService target, SparqlService source, String constructQueryStr, int batchSize) {
        Query query = QueryFactory.create((String)constructQueryStr, (String)"http://example.org/", (Syntax)Syntax.syntaxARQ);
        QueryExecution qe = source.getQueryExecutionFactory().createQueryExecution(query);
        Iterator it = qe.execConstructTriples();
        UnmodifiableIterator itPart = Iterators.partition((Iterator)it, (int)batchSize);
        while (itPart.hasNext()) {
            List part = (List)itPart.next();
            logger.debug("Items in this chunk: " + part.size());
            UpdateExecutionUtils.executeInsertTriples(target.getUpdateExecutionFactory(), part);
        }
        logger.debug("Done with this chunk");
    }

    public static UpdateProcessor executeInsert(org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory uef, Model model) {
        Graph graph = model.getGraph();
        UpdateProcessor result = UpdateExecutionUtils.executeInsert(uef, graph);
        return result;
    }

    public static UpdateProcessor executeInsert(org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory uef, Graph graph) {
        Set triples = graph.find(null, null, null).toSet();
        UpdateProcessor result = UpdateExecutionUtils.executeInsertTriples(uef, triples);
        return result;
    }

    public static void executeUpdate(SparqlService sparqlService, String requestStr, int batchSize, QuadContainmentChecker containmentChecker, Iterable<DatasetListener> listeners) {
        UpdateRequest updateRequest = UpdateRequestUtils.parse((String)requestStr);
        UpdateExecutionUtils.executeUpdate(sparqlService, updateRequest, batchSize, containmentChecker, listeners);
    }

    public static void executeUpdate(SparqlService sparqlService, UpdateRequest request, int batchSize, QuadContainmentChecker containmentChecker, Iterable<DatasetListener> listeners) {
        QueryExecutionFactory qef = sparqlService.getQueryExecutionFactory();
        FN_QuadDiffUnique filter = new FN_QuadDiffUnique(qef, containmentChecker);
        for (Update update : request.getOperations()) {
            UpdateExecutionUtils.executeUpdateCore(sparqlService, update, filter, batchSize, listeners);
        }
    }

    public static String extractWithIri(SparqlService sparqlService, Update update) {
        String result = UpdateUtils.getWithIri((Update)update);
        if (result == null) {
            DatasetDescription datasetDescription = sparqlService.getDatasetDescription();
            result = DatasetDescriptionUtils.getSingleDefaultGraphUri((DatasetDescription)datasetDescription);
        }
        return result;
    }

    public static void executeUpdateCore(SparqlService sparqlService, Update update, Function<Diff<? extends Iterable<Quad>>, Diff<Set<Quad>>> filter, int batchSize, Iterable<DatasetListener> listeners) {
        QueryExecutionFactory qef = sparqlService.getQueryExecutionFactory();
        org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory uef = sparqlService.getUpdateExecutionFactory();
        Node with = NodeUtils.createUriOrNull((String)UpdateExecutionUtils.extractWithIri(sparqlService, update));
        if (with == null) {
            throw new RuntimeException("No target graph for updates could be identified; i.e. no with uri or single default graph specified. " + String.valueOf(update));
        }
        Iterator<Diff<Set<Quad>>> itDiffRaw = UpdateDiffUtils.createIteratorDiff(qef, update, batchSize);
        HashMap<Node, Node> map = new HashMap<Node, Node>();
        map.put(Quad.defaultGraphIRI, with);
        map.put(Quad.defaultGraphNodeGenerated, with);
        NodeTransformRenameMap nodeTransform = NodeTransformRenameMap.create(map);
        Iterator itDiff = Iterators.transform(itDiffRaw, (Function)new Function<Diff<Set<Quad>>, Diff<Set<Quad>>>((NodeTransform)nodeTransform){
            final /* synthetic */ NodeTransform val$nodeTransform;
            {
                this.val$nodeTransform = nodeTransform;
            }

            public Diff<Set<Quad>> apply(Diff<Set<Quad>> input) {
                Set added = (Set)QuadUtils.transformAll(new HashSet(), (NodeTransform)this.val$nodeTransform, (Iterable)((Iterable)input.getAdded()));
                Set removed = (Set)QuadUtils.transformAll(new HashSet(), (NodeTransform)this.val$nodeTransform, (Iterable)((Iterable)input.getRemoved()));
                Diff r = Diff.create((Object)added, (Object)removed);
                return r;
            }
        });
        while (itDiff.hasNext()) {
            Diff filteredDiff;
            Diff diff = (Diff)itDiff.next();
            Diff diff2 = filteredDiff = filter != null ? (Diff)filter.apply((Object)diff) : diff;
            if (listeners != null) {
                UpdateContext updateContext = new UpdateContext(sparqlService, batchSize, null);
                DatasetListenerUtils.notifyListeners(listeners, (Diff<Set<Quad>>)filteredDiff, updateContext);
            }
            UpdateExecutionUtils.executeUpdate(uef, (Diff<? extends Iterable<? extends Quad>>)diff);
        }
    }

    public static UpdateProcessor executeInsertTriples(org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory uef, Iterable<Triple> triples) {
        Iterable quads = Iterables.transform(triples, (Function)FN_QuadFromTriple.fnDefaultGraphNodeGenerated);
        UpdateProcessor result = UpdateExecutionUtils.executeInsertQuads(uef, quads);
        return result;
    }

    public static UpdateProcessor executeDeleteTriples(org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory uef, Iterable<Triple> triples) {
        Iterable quads = Iterables.transform(triples, (Function)FN_QuadFromTriple.fnDefaultGraphNodeGenerated);
        UpdateProcessor result = UpdateExecutionUtils.executeDeleteQuads(uef, quads);
        return result;
    }

    public static UpdateProcessor executeUpdateQuads(org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory uef, Iterable<? extends Quad> quads, boolean isDelete) {
        UpdateProcessor result = isDelete ? UpdateExecutionUtils.executeDeleteQuads(uef, quads) : UpdateExecutionUtils.executeInsertQuads(uef, quads);
        return result;
    }

    public static UpdateProcessor executeInsertQuads(org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory uef, Iterable<? extends Quad> quads) {
        UpdateRequest updateRequest = UpdateRequestUtils.createUpdateRequest(quads, Collections.emptySet());
        UpdateProcessor result = UpdateExecutionUtils.executeUnlessEmpty(uef, updateRequest);
        return result;
    }

    public static UpdateProcessor executeDeleteQuads(org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory uef, Iterable<? extends Quad> quads) {
        UpdateRequest updateRequest = UpdateRequestUtils.createUpdateRequest(Collections.emptySet(), quads);
        UpdateProcessor result = UpdateExecutionUtils.executeUnlessEmpty(uef, updateRequest);
        return result;
    }

    public static UpdateProcessor executeUpdate(org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory uef, Diff<? extends Iterable<? extends Quad>> diff) {
        UpdateRequest updateRequest = UpdateRequestUtils.createUpdateRequest(diff);
        UpdateProcessor result = UpdateExecutionUtils.executeUnlessEmpty(uef, updateRequest);
        return result;
    }

    public static UpdateProcessor executeUpdateDatasetGraph(org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory uef, Diff<? extends DatasetGraph> diff) {
        Diff d = DatasetGraphDiffUtils.wrapDatasetGraph(diff);
        UpdateRequest updateRequest = UpdateRequestUtils.createUpdateRequest((Diff)d);
        UpdateProcessor result = UpdateExecutionUtils.executeUnlessEmpty(uef, updateRequest);
        return result;
    }

    public static UpdateProcessor executeUnlessEmpty(org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory uef, UpdateRequest updateRequest) {
        UpdateProcessor result;
        if (updateRequest.getOperations().isEmpty()) {
            UpdateRequest update = UpdateFactory.create((String)"PREFIX ex: <http://example.org/> INSERT { ex:_s ex:_p ex:_o } WHERE { ex:_s ex:_p ex:_o }");
            result = UpdateExecutionFactory.create((UpdateRequest)update, (Dataset)DatasetFactory.createGeneral());
            result.execute();
        } else {
            result = uef.createUpdateProcessor(updateRequest);
            try {
                result.execute();
            }
            catch (Exception e) {
                RuntimeException f = HttpExceptionUtils.makeHumanFriendly((Exception)e);
                throw f;
            }
        }
        return result;
    }

    public static UpdateProcessor executeUpdateDelta(org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory uef, DatasetGraph after, DatasetGraph before) {
        Diff<Set<Quad>> diff = UpdateDiffUtils.computeDelta(after, before);
        UpdateProcessor result = UpdateExecutionUtils.executeUpdate(uef, diff);
        return result;
    }

    public static UpdateDeleteInsert createUpdateRename(Node g, Node before, Node after, int i) {
        Node[] deleteTerms = new Node[]{g, Vars.s, Vars.p, Vars.o};
        deleteTerms[i] = before;
        Quad deleteQuad = QuadUtils.create((Node[])deleteTerms);
        Node[] insertTerms = new Node[]{g, Vars.s, Vars.p, Vars.o};
        insertTerms[i] = after;
        Quad insertQuad = QuadUtils.create((Node[])insertTerms);
        UpdateDeleteInsert result = new UpdateDeleteInsert();
        result.getDeleteAcc().addQuad(deleteQuad);
        result.getInsertAcc().addQuad(insertQuad);
        result.setElement(ElementUtils.createElement((Quad)deleteQuad));
        return result;
    }

    public static UpdateRequest createUpdateRequestRename(Node graph, Node before, Node after) {
        UpdateRequest result = new UpdateRequest();
        UpdateDeleteInsert g = UpdateExecutionUtils.createUpdateRename(graph, before, after, 0);
        UpdateDeleteInsert s = UpdateExecutionUtils.createUpdateRename(graph, before, after, 1);
        UpdateDeleteInsert p = UpdateExecutionUtils.createUpdateRename(graph, before, after, 2);
        UpdateDeleteInsert o = UpdateExecutionUtils.createUpdateRename(graph, before, after, 3);
        result.add((Update)g);
        result.add((Update)s);
        result.add((Update)p);
        result.add((Update)o);
        return result;
    }

    public static UpdateProcessor executeUpdateRename(org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateExecutionFactory uef, Node graph, Node before, Node after) {
        UpdateRequest updateRequest = UpdateExecutionUtils.createUpdateRequestRename(graph, before, after);
        UpdateProcessor result = UpdateExecutionUtils.executeUnlessEmpty(uef, updateRequest);
        return result;
    }
}

