/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.rx;

import com.google.common.collect.Maps;
import io.reactivex.rxjava3.core.Flowable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.aksw.jenax.sparql.fragment.impl.FragmentUtils;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Var;

public class MapFromBinaryRelation
extends AbstractMap<RDFNode, Collection<RDFNode>> {
    protected Model model;
    protected Fragment2 relation;

    public MapFromBinaryRelation(Model model, Fragment2 relation) {
        this.model = model;
        this.relation = relation;
    }

    @Override
    public Collection<RDFNode> get(Object key) {
        Collection result = null;
        if (key instanceof RDFNode) {
            RDFNode k = (RDFNode)key;
            Fragment2 br = this.relation.joinOn(new Var[]{this.relation.getSourceVar()}).with(ConceptUtils.createFilterConcept((Node[])new Node[]{k.asNode()})).toFragment2();
            result = Optional.ofNullable(MapFromBinaryRelation.fetch(this.model, br)).map(f -> (List)f.map(Map.Entry::getValue).toList().blockingGet()).orElse(null);
        }
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        Object item = this.get(key);
        boolean result = item != null;
        return result;
    }

    @Override
    public Set<Map.Entry<RDFNode, Collection<RDFNode>>> entrySet() {
        Map map = (Map)MapFromBinaryRelation.fetch(this.model, this.relation).toMultimap(Map.Entry::getKey, Map.Entry::getValue).blockingGet();
        return map.entrySet();
    }

    public static Flowable<Map.Entry<RDFNode, RDFNode>> fetch(Model model, Fragment2 relation) {
        Query query = FragmentUtils.createQuery((Fragment)relation);
        Flowable result = SparqlRx.execSelect(() -> QueryExecutionFactory.create((Query)query, (Model)model)).map(qs -> Maps.immutableEntry((Object)qs.get(relation.getSourceVar().getName()), (Object)qs.get(relation.getTargetVar().getName())));
        return result;
    }
}

