/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.http;

import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryBase;
import org.aksw.jena_sparql_api.http.QueryExecutionHttpWrapper;
import org.aksw.jenax.arq.util.dataset.DatasetDescriptionUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;

public class QueryExecutionFactoryHttp
extends QueryExecutionFactoryBase {
    private String service;
    private DatasetDescription datasetDescription;
    private HttpClient httpClient;

    public QueryExecutionFactoryHttp(String service) {
        this(service, Collections.emptySet());
    }

    public QueryExecutionFactoryHttp(String service, String defaultGraphName) {
        this(service, defaultGraphName == null ? Collections.emptySet() : Collections.singleton(defaultGraphName));
    }

    public QueryExecutionFactoryHttp(String service, Collection<String> defaultGraphs) {
        this(service, new DatasetDescription(new ArrayList<String>(defaultGraphs), Collections.emptyList()), null);
    }

    public QueryExecutionFactoryHttp(String service, DatasetDescription datasetDescription, HttpClient httpClient) {
        this.service = service;
        this.datasetDescription = datasetDescription;
        this.httpClient = httpClient;
    }

    public String getId() {
        return this.service;
    }

    public String getState() {
        String result = DatasetDescriptionUtils.toString((DatasetDescription)this.datasetDescription);
        return result;
    }

    public QueryExecution postProcess(QueryExecutionHTTPBuilder builder) {
        this.datasetDescription.getNamedGraphURIs().forEach(arg_0 -> ((QueryExecutionHTTPBuilder)builder).addNamedGraphURI(arg_0));
        this.datasetDescription.getDefaultGraphURIs().forEach(arg_0 -> ((QueryExecutionHTTPBuilder)builder).addDefaultGraphURI(arg_0));
        if (this.httpClient != null) {
            builder.httpClient(this.httpClient);
        }
        Object result = (QueryExecution)builder.build();
        result = new QueryExecutionHttpWrapper((QueryExecution)result);
        return result;
    }

    public QueryExecution createQueryExecution(String queryString) {
        QueryExecutionHTTPBuilder builder = (QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)QueryExecutionHTTPBuilder.create().endpoint(this.service)).query(queryString);
        QueryExecution result = this.postProcess(builder);
        return result;
    }

    public QueryExecution createQueryExecution(Query query) {
        QueryExecutionHTTPBuilder builder = (QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)QueryExecutionHTTPBuilder.create().endpoint(this.service)).query(query);
        QueryExecution result = this.postProcess(builder);
        return result;
    }
}

