/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import org.aksw.jena_sparql_api.core.UpdateExecutionFactoryParsingBase;
import org.aksw.jenax.dataaccess.sparql.execution.update.UpdateEngineFactoryProvider;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.modify.UpdateEngineFactory;
import org.apache.jena.sparql.modify.UpdateEngineRegistry;
import org.apache.jena.sparql.modify.UpdateProcessorBase;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;

public class UpdateExecutionFactoryDataset
extends UpdateExecutionFactoryParsingBase {
    protected Dataset dataset;
    protected Context context;
    protected UpdateEngineFactoryProvider updateEngineFactoryProvider;

    public UpdateExecutionFactoryDataset(Dataset dataset) {
        this(dataset, null);
    }

    public UpdateExecutionFactoryDataset(Dataset dataset, Context context) {
        this(dataset, context, (arg_0, arg_1) -> ((UpdateEngineRegistry)UpdateEngineRegistry.get()).find(arg_0, arg_1));
    }

    public UpdateExecutionFactoryDataset(Dataset dataset, Context context, UpdateEngineFactoryProvider updateEngineFactoryProvider) {
        this.dataset = dataset;
        this.context = context;
        this.updateEngineFactoryProvider = updateEngineFactoryProvider;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public Context getContext() {
        return this.context;
    }

    public UpdateProcessor createUpdateProcessor(UpdateRequest updateRequest) {
        UpdateEngineFactory f;
        if (this.context == null) {
            this.context = ARQ.getContext();
        }
        DatasetGraph dsg = null;
        if (this.dataset != null) {
            dsg = this.dataset.asDatasetGraph();
        }
        if ((f = this.updateEngineFactoryProvider.find(dsg, this.context)) == null) {
            Log.warn(QueryExecutionFactory.class, (String)("Failed to find a QueryEngineFactory for query: " + String.valueOf(updateRequest)));
            return null;
        }
        Binding initialBinding = BindingRoot.create();
        UpdateProcessorBase result = new UpdateProcessorBase(updateRequest, dsg, initialBinding, this.context, f, null);
        return result;
    }
}

