/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.extra;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Iterator;
import org.aksw.commons.util.StreamUtils;
import org.aksw.jena_sparql_api.cache.extra.CacheEntry;
import org.aksw.jena_sparql_api.cache.extra.CacheResource;
import org.aksw.jena_sparql_api.core.utils.ResultSetUtils;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetCloseable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheResourceCacheEntry
implements CacheResource {
    private static Logger logger = LoggerFactory.getLogger(CacheResourceCacheEntry.class);
    protected CacheEntry cacheEntry;
    protected Lang rdfLang;
    protected Lang resultSetLang;

    public CacheResourceCacheEntry(CacheEntry cacheEntry) {
        this(cacheEntry, Lang.RDFTHRIFT, ResultSetLang.RS_Thrift);
    }

    public CacheResourceCacheEntry(CacheEntry cacheEntry, Lang rdfLang, Lang resultSetLang) {
        this.cacheEntry = cacheEntry;
        this.rdfLang = rdfLang;
        this.resultSetLang = resultSetLang;
    }

    @Override
    public ResultSet asResultSet() {
        try {
            return this._asResultSet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ResultSet _asResultSet() throws SQLException {
        InputStream in = this.cacheEntry.getInputStream();
        ResultSet resultSet = ResultSetMgr.read((InputStream)in, (Lang)this.resultSetLang);
        ResultSetCloseable result = ResultSetUtils.wrap(resultSet, in);
        return result;
    }

    @Override
    public boolean isOutdated() {
        return System.currentTimeMillis() - this.cacheEntry.getTimestamp() > this.cacheEntry.getLifespan();
    }

    @Override
    public Model asModel(Model result) {
        try {
            return this._asModel(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Model _asModel(Model result) throws SQLException {
        try (InputStream in = this.cacheEntry.getInputStream();){
            RDFDataMgr.read((Model)result, (InputStream)in, (Lang)this.rdfLang);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public boolean asBoolean() {
        try {
            return this._asBoolean();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean _asBoolean() throws SQLException, IOException {
        String str = StreamUtils.toString((InputStream)this.cacheEntry.getInputStream());
        boolean result = Boolean.parseBoolean(str);
        return result;
    }

    @Override
    public void close() {
        try {
            this.cacheEntry.getInputStream().close();
        }
        catch (IOException e) {
            logger.warn("Error", (Throwable)e);
        }
    }

    @Override
    public Iterator<Triple> asIteratorTriples() {
        InputStream in = this.cacheEntry.getInputStream();
        Iterator result = RDFDataMgr.createIteratorTriples((InputStream)in, (Lang)this.rdfLang, null);
        return result;
    }
}

