/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.core;

import java.io.IOException;
import org.aksw.jena_sparql_api.cache.core.ModelProvider;
import org.aksw.jena_sparql_api.cache.extra.Cache;
import org.aksw.jena_sparql_api.cache.extra.CacheResource;
import org.aksw.jenax.dataaccess.sparql.execution.query.QueryExecutionWrapperBase;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionCache
extends QueryExecutionWrapperBase<QueryExecution> {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionCache.class);
    private Cache cache;
    private String queryString;

    public QueryExecutionCache(QueryExecution decoratee, String queryString, Cache cache) {
        super(decoratee);
        this.queryString = queryString;
        this.cache = cache;
    }

    public ResultSet doCacheResultSet() {
        CacheResource resource = this.cache.lookup(this.queryString);
        if (resource == null || resource.isOutdated()) {
            ResultSet rs;
            try {
                rs = this.getDelegate().execSelect();
            }
            catch (Exception e) {
                logger.warn("Error communicating with backend", (Throwable)e);
                if (resource != null) {
                    return resource.asResultSet();
                }
                throw new RuntimeException(e);
            }
            logger.trace("Cache write: " + this.queryString);
            this.cache.write(this.queryString, rs);
            resource = this.cache.lookup(this.queryString);
            if (resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit: " + this.queryString);
        }
        return resource.asResultSet();
    }

    public Model doCacheModel(Model result, ModelProvider modelProvider) {
        try {
            return this._doCacheModel(result, modelProvider);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Model _doCacheModel(Model result, ModelProvider modelProvider) throws IOException {
        CacheResource resource = this.cache.lookup(this.queryString);
        Model model = ModelFactory.createDefaultModel();
        if (resource == null || resource.isOutdated()) {
            try {
                model = modelProvider.getModel();
            }
            catch (Exception e) {
                logger.warn("Error communicating with backend", (Throwable)e);
                if (resource != null) {
                    model = resource.asModel(model);
                    result.add(model);
                    return result;
                }
                throw new RuntimeException(e);
            }
            logger.trace("Cache write: " + this.queryString);
            this.cache.write(this.queryString, model);
            resource = this.cache.lookup(this.queryString);
            if (resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit: " + this.queryString);
        }
        return resource.asModel(result);
    }

    public boolean doCacheBoolean() {
        CacheResource resource = this.cache.lookup(this.queryString);
        if (resource == null || resource.isOutdated()) {
            boolean ret;
            try {
                ret = this.getDelegate().execAsk();
            }
            catch (Exception e) {
                logger.warn("Error communicating with backend", (Throwable)e);
                if (resource != null) {
                    return resource.asBoolean();
                }
                throw new RuntimeException(e);
            }
            logger.trace("Cache write: " + this.queryString);
            this.cache.write(this.queryString, ret);
            resource = this.cache.lookup(this.queryString);
            if (resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit: " + this.queryString);
        }
        return resource.asBoolean();
    }

    public ResultSet execSelect() {
        return this.doCacheResultSet();
    }

    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    public Model execConstruct(Model model) {
        return this.doCacheModel(model, new ModelProvider(){

            @Override
            public Model getModel() {
                return QueryExecutionCache.this.getDelegate().execConstruct();
            }
        });
    }

    public Model execDescribe() {
        return this.execDescribe(ModelFactory.createDefaultModel());
    }

    public Model execDescribe(Model model) {
        return this.doCacheModel(model, new ModelProvider(){

            @Override
            public Model getModel() {
                return QueryExecutionCache.this.getDelegate().execDescribe();
            }
        });
    }

    public boolean execAsk() {
        return this.doCacheBoolean();
    }
}

