/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.common;

import com.google.common.io.Resources;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.util.prefix.PrefixMappingTrie;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sys.JenaSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPrefixes {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPrefixes.class);
    private static PrefixMapping prefixes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PrefixMapping get() {
        if (prefixes != null) return prefixes;
        Class<DefaultPrefixes> clazz = DefaultPrefixes.class;
        synchronized (DefaultPrefixes.class) {
            if (prefixes != null) return prefixes;
            prefixes = new PrefixMappingTrie();
            DefaultPrefixes.load(prefixes);
            // ** MonitorExit[var0] (shouldn't be in output)
            return prefixes;
        }
    }

    public static void load(PrefixMapping target) {
        target.setNsPrefixes((PrefixMapping)RDFDataMgr.loadModel((String)"rdf-prefixes/jena-extended.jsonld")).setNsPrefixes((PrefixMapping)RDFDataMgr.loadModel((String)"rdf-prefixes/arq.jsonld")).setNsPrefixes((PrefixMapping)RDFDataMgr.loadModel((String)"rdf-prefixes/rdfa11.jsonld")).setNsPrefixes((PrefixMapping)RDFDataMgr.loadModel((String)"rdf-prefixes/geosparql.jsonld")).setNsPrefixes((PrefixMapping)RDFDataMgr.loadModel((String)"rdf-prefixes/dataid.jsonld")).setNsPrefixes((PrefixMapping)RDFDataMgr.loadModel((String)"rdf-prefixes/jsa.jsonld")).setNsPrefixes((PrefixMapping)RDFDataMgr.loadModel((String)"rdf-prefixes/rpif.jsonld"));
    }

    public static void toImproveInTheFuture() {
        List files;
        String folder = "rdf-prefixes";
        String rootStr = Resources.getResource((String)folder).getPath();
        Path rootPath = Paths.get(rootStr, new String[0]);
        try {
            files = Files.walk(rootPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> folder + "/" + rootPath.relativize((Path)path).toString()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String file : files) {
            Lang lang = RDFDataMgr.determineLang((String)file, null, null);
            if (lang == null) {
                logger.warn("Skipped prefix resource: Could not determine lang of " + file);
                continue;
            }
            Model model = RDFDataMgr.loadModel((String)file, (Lang)lang);
            prefixes.setNsPrefixes((PrefixMapping)model);
        }
    }

    static {
        JenaSystem.init();
    }
}

