/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.reprogen.shared;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jenax.annotation.reprogen.Iri;
import org.aksw.jenax.annotation.reprogen.IriNs;
import org.aksw.jenax.annotation.reprogen.ToString;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Path0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationUtils {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationUtils.class);

    public static List<String> deriveIrisFromMethod(Method method, PrefixMapping pm) {
        Iri[] iris;
        ArrayList<String> result = new ArrayList<String>();
        for (Iri iri : iris = (Iri[])method.getAnnotationsByType(Iri.class)) {
            String expanded;
            String rdfPropertyStr = iri.value();
            String contrib = expanded = pm.expandPrefix(rdfPropertyStr);
            if (logger.isDebugEnabled()) {
                logger.debug("Found @Iri annotation on " + String.valueOf(method) + ":");
                if (Objects.equals(rdfPropertyStr, expanded)) {
                    logger.debug("  " + rdfPropertyStr);
                } else {
                    logger.debug("  " + rdfPropertyStr + " expanded to " + String.valueOf(result));
                }
            }
            result.add(contrib);
        }
        IriNs[] iriNss = (IriNs[])method.getAnnotationsByType(IriNs.class);
        String localName = AnnotationUtils.deriveBeanPropertyName(method.getName());
        for (IriNs iriNs : iriNss) {
            String uri;
            String ns = iriNs.value();
            if (ns.contains(":")) {
                uri = ns;
            } else {
                uri = pm.getNsPrefixURI(ns);
                if (uri == null) {
                    throw new RuntimeException("Undefined prefix: " + ns + " on method " + String.valueOf(method));
                }
            }
            String contrib = uri + localName;
            result.add(contrib);
        }
        return result;
    }

    public static String deriveBeanPropertyName(String methodName) {
        String result;
        List<String> prefixes = Arrays.asList("get", "set", "is");
        String usedPrefix = prefixes.stream().filter(methodName::startsWith).findAny().orElse(null);
        if (usedPrefix != null) {
            result = methodName.substring(usedPrefix.length());
            if (result.isEmpty()) {
                result = usedPrefix;
            }
        } else {
            result = methodName;
        }
        result = Introspector.decapitalize(result);
        return result;
    }

    public static List<P_Path0> derivePathsFromMethod(Method method, PrefixMapping pm) {
        List<P_Path0> result = AnnotationUtils.deriveIrisFromMethod(method, pm).stream().map(NodeFactory::createURI).map(P_Link::new).collect(Collectors.toList());
        return result;
    }

    public static Set<String> indexToStringByBeanPropertyName(Class<?> clazz) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            String beanPropertyName = AnnotationUtils.deriveBeanPropertyName(methodName);
            ToString toString = method.getAnnotation(ToString.class);
            if (toString == null) continue;
            result.add(beanPropertyName);
        }
        return result;
    }

    public static Map<String, P_Path0> indexPathsByBeanPropertyName(Class<?> clazz, PrefixMapping pm) {
        LinkedHashMap<String, P_Path0> result = new LinkedHashMap<String, P_Path0>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            String beanPropertyName = AnnotationUtils.deriveBeanPropertyName(methodName);
            List<P_Path0> paths = AnnotationUtils.derivePathsFromMethod(method, pm);
            for (P_Path0 path : paths) {
                result.put(beanPropertyName, path);
            }
        }
        return result;
    }
}

