/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.model;

import java.util.function.Function;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeFactoryImpl;
import org.aksw.jena_sparql_api.mapper.model.RdfType;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;

public class F_ObjectToNode
implements Function<Object, Node> {
    protected TypeMapper typeMapper;
    protected RdfTypeFactoryImpl rdfClassFactory;

    public F_ObjectToNode(RdfTypeFactoryImpl rdfClassFactory, TypeMapper typeMapper) {
        this.rdfClassFactory = rdfClassFactory;
        this.typeMapper = typeMapper;
    }

    @Override
    public Node apply(Object o) {
        Node result;
        Class<?> clazz = o.getClass();
        if (String.class.isAssignableFrom(clazz)) {
            // empty if block
        }
        if (clazz.isPrimitive()) {
            result = NodeUtils.createTypedLiteral((TypeMapper)this.typeMapper, (Object)o);
        } else {
            RdfType rdfType = this.rdfClassFactory.forJavaType(clazz);
            result = rdfType.getRootNode(o);
        }
        return result;
    }
}

