/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.jpa.criteria;

import java.util.HashMap;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import org.aksw.jena_sparql_api.mapper.impl.type.PathResolver;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.PathVisitor;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.VPath;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Element;

public class PathResolverVarMapper
implements PathVisitor<Var> {
    protected PathResolver currentState;
    protected Set<Element> elements;
    protected Function<Expression<?>, String> aliasMapper;

    public PathResolverVarMapper(PathResolver currentState, Set<Element> elements, Function<Expression<?>, String> aliasMapper) {
        this.currentState = currentState;
        this.elements = elements;
        this.aliasMapper = aliasMapper;
    }

    public Set<Element> getElements() {
        return this.elements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Var visit(VPath<?> path) {
        if (path instanceof Root) {
            Root root = (Root)path;
            String rootAlias = this.aliasMapper.apply((Expression<?>)root);
            return Var.alloc((String)rootAlias);
        }
        if (!(path instanceof VPath)) throw new RuntimeException("Don't know how to handle: " + String.valueOf(path));
        Path parentPath = path.getParentPath();
        VPath pp = (VPath)parentPath;
        Var sourceVar = pp.accept(this);
        String attrName = path.getReachingAttributeName();
        if (this.currentState == null) throw new RuntimeException("Could not resolve path: " + String.valueOf(path));
        this.currentState = this.currentState.resolve(attrName);
        String targetAlias = this.aliasMapper.apply(path);
        Var targetVar = Var.alloc((String)targetAlias);
        Fragment2 r = this.currentState.getRelation();
        HashMap<Var, Var> varMap = new HashMap<Var, Var>();
        varMap.put(r.getSourceVar(), sourceVar);
        varMap.put(r.getTargetVar(), targetVar);
        Set vars = r.getVarsMentioned();
        vars.remove(r.getSourceVar());
        vars.remove(r.getTargetVar());
        vars.forEach(v -> varMap.put((Var)v, Var.alloc((String)(targetAlias + "_" + v.getName()))));
        Element renamedElement = ElementUtils.createRenamedElement((Element)r.getElement(), varMap);
        this.elements.add(renamedElement);
        return targetVar;
    }

    public static <T> Stream<T> enumerate(T item, Function<? super T, T> predecessorFn) {
        Stream result = item == null ? Stream.empty() : Stream.concat(Stream.of(item), PathResolverVarMapper.enumerate(predecessorFn.apply(item), predecessorFn));
        return result;
    }

    public static <T> T getFirstItem(T item, Function<T, T> predecessor) {
        T result = item;
        if (result != null) {
            T parentItem;
            while ((parentItem = predecessor.apply(result)) != null) {
                result = parentItem;
            }
        }
        return result;
    }

    public static Path<?> getRootPath(Path<?> path) {
        Path result = PathResolverVarMapper.getFirstItem(path, Path::getParentPath);
        return result;
    }

    public static Class<?> getRootClass(Path<?> path) {
        Path<?> rootPath = PathResolverVarMapper.getRootPath(path);
        Class result = rootPath == null ? null : rootPath.getJavaType();
        return result;
    }
}

