/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.aksw.jenax.sparql.fragment.impl.PropertyRelation;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfSeqUtils {
    public static final PropertyRelation seqRelation = PropertyRelation.create((String)"?s ?p ?o . Filter(regex(?p, 'http://www.w3.org/1999/02/22-rdf-syntax-ns#_[0-9]+'))", (String)"s", (String)"p", (String)"o");
    public static final Expr seqExpr = ExprUtils.parse((String)"regex(?p, 'http://www.w3.org/1999/02/22-rdf-syntax-ns#_[0-9]+')");
    private static final Logger logger = LoggerFactory.getLogger(RdfSeqUtils.class);

    public static <K extends Number, V> List<V> toList(Map<K, V> map) {
        Number tmp = (Number)Collections.max(map.keySet());
        int size = tmp == null ? 0 : tmp.intValue();
        ArrayList<V> result = new ArrayList<V>(size);
        result.addAll(Collections.nCopies(size, null));
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Number key = (Number)entry.getKey();
            int index = key.intValue();
            V val = entry.getValue();
            result.set(index, val);
        }
        return result;
    }

    public List<Node> readSeq(DatasetGraph datasetGraph, Node g, Node s) {
        Iterator it = datasetGraph.find(g, s, Node.ANY, Node.ANY);
        TreeMap<Integer, Node> indexToValue = new TreeMap<Integer, Node>();
        String prefix = RDF.getURI() + "_";
        int l = prefix.length();
        while (it.hasNext()) {
            Quad q = (Quad)it.next();
            Node o = q.getObject();
            String p = q.getPredicate().getURI();
            boolean isMembership = p.startsWith(prefix);
            if (!isMembership) continue;
            String sub = p.substring(l);
            Integer i = Integer.parseInt(sub);
            if (i != null) {
                indexToValue.put(i - 1, o);
                continue;
            }
            logger.warn("Ignoring invalid index in seq: " + i);
        }
        List<Node> result = RdfSeqUtils.toList(indexToValue);
        return result;
    }

    public static void writeSeq(DatasetGraph target, List<Node> items, Node g, Node s) {
        Quad type = new Quad(g, s, RDF.type.asNode(), RDF.Seq.asNode());
        target.add(type);
        for (int i = 0; i < items.size(); ++i) {
            Node p = RDF.li((int)(i + 1)).asNode();
            Node o = items.get(i);
            if (o == null) continue;
            Quad quad = new Quad(g, s, p, o);
            target.add(quad);
        }
    }
}

