/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.impl.engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.graph.GraphFactory;

public class EntityGraphMap<K> {
    protected Graph graph;
    protected Map<K, Graph> keyToGraph = new HashMap<K, Graph>();
    protected Map<Triple, Set<K>> tripleToKeys = new HashMap<Triple, Set<K>>();

    public void putAll(Graph graph, K key) {
        for (Triple triple : graph.find(Node.ANY, Node.ANY, Node.ANY).toSet()) {
            this.put(triple, key);
        }
    }

    public void removeAll(Graph graph, K key) {
        for (Triple triple : graph.find(Node.ANY, Node.ANY, Node.ANY).toSet()) {
            this.remove(triple, key);
        }
    }

    public void clearGraph(K key) {
        Graph graph = this.keyToGraph.get(key);
        if (graph != null) {
            this.removeAll(graph, key);
        }
    }

    public void put(Triple triple, K key) {
        this.tripleToKeys.computeIfAbsent(triple, t -> new HashSet()).add(key);
        Graph graph = this.keyToGraph.get(key);
        if (graph == null) {
            graph = GraphFactory.createDefaultGraph();
            this.keyToGraph.put(key, graph);
        }
        graph.add(triple);
    }

    public void remove(Triple triple, K key) {
        Graph g;
        Set<K> keys = this.tripleToKeys.get(key);
        if (keys != null) {
            keys.remove(keys);
        }
        if ((g = this.keyToGraph.get(key)) != null) {
            g.remove(triple.getSubject(), triple.getPredicate(), triple.getObject());
            if (this.graph.isEmpty()) {
                this.keyToGraph.remove(key);
            }
        }
    }

    public void removeTriple(Triple triple) {
        Set<K> keys = this.tripleToKeys.get(triple);
        if (keys != null) {
            keys.remove(triple);
            for (K entity : keys) {
                Graph graph = this.keyToGraph.get(entity);
                if (graph == null) continue;
                graph.remove(triple.getSubject(), triple.getPredicate(), triple.getObject());
            }
        }
    }

    public void removeEntity(Object entity) {
        Graph graph = this.keyToGraph.get(entity);
        this.keyToGraph.remove(entity);
        if (graph != null) {
            for (Triple triple : graph.find(Node.ANY, Node.ANY, Node.ANY).toSet()) {
                Set<K> keys = this.tripleToKeys.get(triple);
                keys.remove(entity);
            }
        }
    }

    public Graph getGraphForKey(Object key) {
        Graph result = this.keyToGraph.get(key);
        return result;
    }
}

